/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.hazelcast.HazelcastLock;
import net.javacrumbs.shedlock.provider.hazelcast.HazelcastSimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastLockProvider
implements LockProvider {
    private static final Logger log = LoggerFactory.getLogger(HazelcastLockProvider.class);
    static final String LOCK_STORE_KEY_DEFAULT = "shedlock_storage";
    private final String lockStoreKey;
    private HazelcastInstance hazelcastInstance;

    public HazelcastLockProvider(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, LOCK_STORE_KEY_DEFAULT);
    }

    public HazelcastLockProvider(HazelcastInstance hazelcastInstance, String lockStoreKey) {
        this.hazelcastInstance = hazelcastInstance;
        this.lockStoreKey = lockStoreKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        log.trace("lock - Attempt : {}", (Object)lockConfiguration);
        Instant now = Instant.now();
        String lockName = lockConfiguration.getName();
        IMap<String, HazelcastLock> store = this.getStore();
        try {
            store.lock((Object)lockName);
            if (this.tryLock(lockConfiguration, now)) {
                Optional<SimpleLock> optional = Optional.of(new HazelcastSimpleLock(this, lockName));
                return optional;
            }
        }
        finally {
            store.unlock((Object)lockName);
        }
        return Optional.empty();
    }

    private boolean tryLock(LockConfiguration lockConfiguration, Instant now) {
        String lockName = lockConfiguration.getName();
        HazelcastLock lock = this.getLock(lockName);
        if (this.isUnlocked(lock)) {
            log.debug("lock - lock obtained, it wasn't locked : conf={}", (Object)lockConfiguration);
            this.addNewLock(lockConfiguration);
            return true;
        }
        if (this.isExpired(lock, now)) {
            log.debug("lock - lock obtained, it was locked but expired : oldLock={};  conf={}", (Object)lock, (Object)lockConfiguration);
            this.replaceLock(lockName, lockConfiguration);
            return true;
        }
        log.debug("lock - already locked : currentLock={};  conf={}", (Object)lock, (Object)lockConfiguration);
        return false;
    }

    private IMap<String, HazelcastLock> getStore() {
        return this.hazelcastInstance.getMap(this.lockStoreKey);
    }

    HazelcastLock getLock(String lockName) {
        return (HazelcastLock)this.getStore().get((Object)lockName);
    }

    private void removeLock(String lockName) {
        this.getStore().delete((Object)lockName);
        log.debug("lock store - lock deleted : {}", (Object)lockName);
    }

    private void addNewLock(LockConfiguration lockConfiguration) {
        HazelcastLock lock = HazelcastLock.fromConfigurationWhereTtlIsUntilTime(lockConfiguration);
        log.trace("lock store - new lock created from configuration : {}", (Object)lockConfiguration);
        String lockName = lockConfiguration.getName();
        this.getStore().put((Object)lockName, (Object)lock);
        log.debug("lock store - new lock added : {}", (Object)lock);
    }

    private void replaceLock(String lockName, LockConfiguration lockConfiguration) {
        log.debug("lock store - replace lock : {}", (Object)lockName);
        this.removeLock(lockName);
        this.addNewLock(lockConfiguration);
    }

    private boolean isUnlocked(HazelcastLock lock) {
        return lock == null;
    }

    private boolean isExpired(HazelcastLock lock, Instant now) {
        Instant timeToLive = lock.getTimeToLive();
        return !now.isBefore(timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(String lockName) {
        log.trace("unlock - attempt : {}", (Object)lockName);
        Instant now = Instant.now();
        IMap<String, HazelcastLock> store = this.getStore();
        try {
            store.lock((Object)lockName);
            HazelcastLock lock = this.getLock(lockName);
            this.unlockProperly(lock, now);
        }
        finally {
            store.unlock((Object)lockName);
        }
    }

    private void unlockProperly(HazelcastLock lock, Instant now) {
        if (this.isUnlocked(lock)) {
            log.debug("unlock - it is already unlocked");
            return;
        }
        String lockName = lock.getName();
        Instant lockAtLeastInstant = lock.getLockAtLeastUntil();
        if (!now.isBefore(lockAtLeastInstant)) {
            this.removeLock(lockName);
            log.debug("unlock - done : {}", (Object)lock);
        } else {
            log.debug("unlock - it doesn't unlock, least time is not passed : {}", (Object)lock);
            HazelcastLock newLock = HazelcastLock.fromLockWhereTtlIsReduceToLeastTime(lock);
            this.getStore().put((Object)lockName, (Object)newLock);
        }
    }
}

