/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.hazelcast;

import java.io.Serializable;
import java.time.Instant;
import net.javacrumbs.shedlock.core.LockConfiguration;

class HazelcastLock
implements Serializable {
    private final String name;
    private final Instant lockAtMostUntil;
    private final Instant lockAtLeastUntil;
    private final Instant timeToLive;

    private HazelcastLock(String name, Instant lockAtMostUntil, Instant lockAtLeastUntil, Instant timeToLive) {
        this.name = name;
        this.lockAtMostUntil = lockAtMostUntil;
        this.lockAtLeastUntil = lockAtLeastUntil;
        this.timeToLive = timeToLive;
    }

    boolean isExpired(Instant now) {
        return !now.isBefore(this.getTimeToLive());
    }

    static HazelcastLock fromConfigurationWhereTtlIsUntilTime(LockConfiguration configuration) {
        return new HazelcastLock(configuration.getName(), configuration.getLockAtMostUntil(), configuration.getLockAtLeastUntil(), configuration.getLockAtMostUntil());
    }

    static HazelcastLock fromLockWhereTtlIsReduceToLeastTime(HazelcastLock lock) {
        return new HazelcastLock(lock.name, lock.lockAtMostUntil, lock.lockAtLeastUntil, lock.lockAtLeastUntil);
    }

    String getName() {
        return this.name;
    }

    Instant getLockAtLeastUntil() {
        return this.lockAtLeastUntil;
    }

    Instant getTimeToLive() {
        return this.timeToLive;
    }

    public String toString() {
        return "HazelcastLock{name='" + this.name + '\'' + ", lockAtMostUntil=" + this.lockAtMostUntil + ", lockAtLeastUntil=" + this.lockAtLeastUntil + ", timeToLive=" + this.timeToLive + '}';
    }
}

