/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.HashMap;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class Db2ServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "(CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    private static final String lockAtMostFor = "((CURRENT TIMESTAMP - CURRENT TIMEZONE) + :lockAtMostForMicros MICROSECONDS)";

    Db2ServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, " + lockAtMostFor + ", " + now + ", :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + lockAtMostFor + ", " + this.lockedAt() + " = " + now + ", " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= " + now;
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = "(" + this.lockedAt() + "+ :lockAtLeastForMicros MICROSECONDS)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > " + now + " THEN " + lockAtLeastFor + " ELSE " + now + " END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + lockAtMostFor + " WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > " + now;
    }

    @Override
    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockedBy", this.configuration.getLockedByValue());
        params.put("lockAtMostForMicros", (double)lockConfiguration.getLockAtMostFor().toNanos() / 1000.0);
        params.put("lockAtLeastForMicros", (double)lockConfiguration.getLockAtLeastFor().toNanos() / 1000.0);
        return params;
    }
}

