/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplateLockProvider.Configuration configuration;

    JdbcTemplateStorageAccessor(@NotNull JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration can not be null");
        this.jdbcTemplate = configuration.getJdbcTemplate();
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(this.jdbcTemplate.getDataSource());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    public boolean insertRecord(@NotNull LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(?, ?, ?, ?)";
        return (Boolean)this.transactionTemplate.execute(status -> {
            try {
                int insertedRows = this.jdbcTemplate.update(sql, preparedStatement -> {
                    preparedStatement.setString(1, lockConfiguration.getName());
                    this.setTimestamp(preparedStatement, 2, lockConfiguration.getLockAtMostUntil());
                    this.setTimestamp(preparedStatement, 3, Instant.now());
                    preparedStatement.setString(4, this.lockedByValue());
                });
                return insertedRows > 0;
            }
            catch (DuplicateKeyException e) {
                return false;
            }
            catch (DataIntegrityViolationException e) {
                this.logger.warn("Unexpected exception", (Throwable)e);
                return false;
            }
        });
    }

    public boolean updateRecord(@NotNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = ?, " + this.lockedAt() + " = ?, " + this.lockedBy() + " = ? WHERE " + this.name() + " = ? AND " + this.lockUntil() + " <= ?";
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, statement -> {
                Instant now = Instant.now();
                this.setTimestamp(statement, 1, lockConfiguration.getLockAtMostUntil());
                this.setTimestamp(statement, 2, now);
                statement.setString(3, this.lockedByValue());
                statement.setString(4, lockConfiguration.getName());
                this.setTimestamp(statement, 5, now);
            });
            return updatedRows > 0;
        });
    }

    public boolean extend(@NotNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = ? WHERE " + this.name() + " = ? AND " + this.lockedBy() + " = ? AND " + this.lockUntil() + " > ? ";
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, statement -> {
                this.setTimestamp(statement, 1, lockConfiguration.getLockAtMostUntil());
                statement.setString(2, lockConfiguration.getName());
                statement.setString(3, this.lockedByValue());
                this.setTimestamp(statement, 4, Instant.now());
            });
            return updatedRows > 0;
        });
    }

    private void setTimestamp(PreparedStatement preparedStatement, int parameterIndex, Instant time) throws SQLException {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone == null) {
            preparedStatement.setTimestamp(parameterIndex, Timestamp.from(time));
        } else {
            preparedStatement.setTimestamp(parameterIndex, Timestamp.from(time), Calendar.getInstance(timeZone));
        }
    }

    public void unlock(final @NotNull LockConfiguration lockConfiguration) {
        final String sql = "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = ? WHERE " + this.name() + " = ?";
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcTemplateStorageAccessor.this.jdbcTemplate.update(sql, statement -> {
                    JdbcTemplateStorageAccessor.this.setTimestamp(statement, 1, lockConfiguration.getUnlockTime());
                    statement.setString(2, lockConfiguration.getName());
                });
            }
        });
    }

    private String name() {
        return this.configuration.getColumnNames().getName();
    }

    private String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    private String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    private String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    private String lockedByValue() {
        return this.configuration.getLockedByValue();
    }

    private String tableName() {
        return this.configuration.getTableName();
    }
}

