/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplateLockProvider.Configuration configuration;
    private final SqlStatementsSource sqlStatementsSource;

    JdbcTemplateStorageAccessor(@NotNull JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration can not be null");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)configuration.getJdbcTemplate());
        this.sqlStatementsSource = SqlStatementsSource.create(configuration);
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(configuration.getJdbcTemplate().getDataSource());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    public boolean insertRecord(@NotNull LockConfiguration lockConfiguration) {
        try {
            String sql = this.sqlStatementsSource.getInsertStatement();
            return (Boolean)this.transactionTemplate.execute(status -> {
                Map<String, Object> params = this.params(lockConfiguration);
                int insertedRows = this.jdbcTemplate.update(sql, params);
                return insertedRows > 0;
            });
        }
        catch (DuplicateKeyException e) {
            return false;
        }
        catch (DataIntegrityViolationException e) {
            this.logger.warn("Unexpected exception", (Throwable)e);
            return false;
        }
    }

    public boolean updateRecord(@NotNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource.getUpdateStatement();
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, this.params(lockConfiguration));
            return updatedRows > 0;
        });
    }

    public boolean extend(@NotNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource.getExtendStatement();
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, this.params(lockConfiguration));
            return updatedRows > 0;
        });
    }

    public void unlock(final @NotNull LockConfiguration lockConfiguration) {
        final String sql = this.sqlStatementsSource.getUnlockStatement();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcTemplateStorageAccessor.this.jdbcTemplate.update(sql, JdbcTemplateStorageAccessor.this.params(lockConfiguration));
            }
        });
    }

    @NotNull
    private Map<String, Object> params(@NotNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockUntil", this.timestamp(lockConfiguration.getLockAtMostUntil()));
        params.put("now", this.timestamp(ClockProvider.now()));
        params.put("lockedBy", this.lockedByValue());
        params.put("unlockTime", this.timestamp(lockConfiguration.getUnlockTime()));
        return params;
    }

    @NotNull
    private Object timestamp(Instant time) {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone == null) {
            return Timestamp.from(time);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(time));
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    private String lockedByValue() {
        return this.configuration.getLockedByValue();
    }
}

