/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlStatementsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlStatementsSource {
    private final JdbcTemplateLockProvider.Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SqlStatementsSource.class);

    SqlStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = configuration;
    }

    static SqlStatementsSource create(JdbcTemplateLockProvider.Configuration configuration) {
        String databaseProductName = SqlStatementsSource.getDatabaseProductName(configuration);
        if ("PostgreSQL".equals(databaseProductName)) {
            logger.debug("Using PostgresSqlStatementsSource");
            return new PostgresSqlStatementsSource(configuration);
        }
        logger.debug("Using SqlStatementsSource");
        return new SqlStatementsSource(configuration);
    }

    private static String getDatabaseProductName(JdbcTemplateLockProvider.Configuration configuration) {
        return (String)configuration.getJdbcTemplate().execute(connection -> connection.getMetaData().getDatabaseProductName());
    }

    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, :lockUntil, :now, :lockedBy)";
    }

    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil, " + this.lockedAt() + " = :now, " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= :now";
    }

    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > :now";
    }

    public String getUnlockStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :unlockTime WHERE " + this.name() + " = :name";
    }

    String name() {
        return this.configuration.getColumnNames().getName();
    }

    String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    String tableName() {
        return this.configuration.getTableName();
    }
}

