/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.HashMap;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class Db2ServerTimeStatementsSource
extends SqlStatementsSource {
    private final String now = "(CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    private final String lockAtMostFor = "ADD_SECONDS((CURRENT TIMESTAMP - CURRENT TIMEZONE), :lockAtMostForSeconds)";

    Db2ServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, " + "ADD_SECONDS((CURRENT TIMESTAMP - CURRENT TIMEZONE), :lockAtMostForSeconds)" + ", " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)" + ", :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + "ADD_SECONDS((CURRENT TIMESTAMP - CURRENT TIMEZONE), :lockAtMostForSeconds)" + ", " + this.lockedAt() + " = " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)" + ", " + this.lockedBy() + " = :lockedBy WHERE " + this.lockUntil() + " <= " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = "ADD_SECONDS(" + this.lockedAt() + ", :lockAtLeastForSeconds)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)" + " THEN " + lockAtLeastFor + " ELSE " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)" + " END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + "ADD_SECONDS((CURRENT TIMESTAMP - CURRENT TIMEZONE), :lockAtMostForSeconds)" + " WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > " + "(CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    }

    @Override
    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockedBy", this.configuration.getLockedByValue());
        params.put("lockAtMostForSeconds", (double)lockConfiguration.getLockAtMostFor().toMillis() / 1000.0);
        params.put("lockAtLeastForSeconds", (double)lockConfiguration.getLockAtLeastFor().toMillis() / 1000.0);
        return params;
    }
}

