/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Map;
import java.util.Objects;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplateLockProvider.Configuration configuration;
    private SqlStatementsSource sqlStatementsSource;

    JdbcTemplateStorageAccessor(@NonNull JdbcTemplateLockProvider.Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration can not be null");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)configuration.getJdbcTemplate());
        this.configuration = configuration;
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(configuration.getJdbcTemplate().getDataSource());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
        if (configuration.getIsolationLevel() != null) {
            this.transactionTemplate.setIsolationLevel(configuration.getIsolationLevel().intValue());
        }
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        try {
            String sql = this.sqlStatementsSource().getInsertStatement();
            return this.execute(sql, lockConfiguration);
        }
        catch (ConcurrencyFailureException | DuplicateKeyException | TransactionSystemException e) {
            this.logger.debug("Duplicate key", e);
            return false;
        }
        catch (DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            this.logger.error("Unexpected exception", e);
            return false;
        }
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getUpdateStatement();
        try {
            return this.execute(sql, lockConfiguration);
        }
        catch (ConcurrencyFailureException e) {
            this.logger.debug("Serialization exception", (Throwable)e);
            return false;
        }
        catch (DataIntegrityViolationException | TransactionSystemException e) {
            this.logger.error("Unexpected exception", e);
            return false;
        }
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getExtendStatement();
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.execute(sql, lockConfiguration);
    }

    public void unlock(@NonNull LockConfiguration lockConfiguration) {
        try {
            this.doUnlock(lockConfiguration);
        }
        catch (ConcurrencyFailureException | TransactionSystemException e) {
            this.logger.info("Unlock failed due to TransactionSystemException - retrying");
            this.doUnlock(lockConfiguration);
        }
    }

    private void doUnlock(LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getUnlockStatement();
        this.execute(sql, lockConfiguration);
    }

    private boolean execute(String sql, LockConfiguration lockConfiguration) throws TransactionException {
        return (Boolean)this.transactionTemplate.execute(status -> this.jdbcTemplate.update(sql, this.params(lockConfiguration)) > 0);
    }

    @NonNull
    private Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        return this.sqlStatementsSource().params(lockConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlStatementsSource sqlStatementsSource() {
        JdbcTemplateLockProvider.Configuration configuration = this.configuration;
        synchronized (configuration) {
            if (this.sqlStatementsSource == null) {
                this.sqlStatementsSource = SqlStatementsSource.create(this.configuration);
            }
            return this.sqlStatementsSource;
        }
    }
}

