/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class PostgresSqlServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "timezone('utc', CURRENT_TIMESTAMP)";
    private static final String lockAtMostFor = "timezone('utc', CURRENT_TIMESTAMP) + cast(:lockAtMostForInterval as interval)";

    PostgresSqlServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, timezone('utc', CURRENT_TIMESTAMP) + cast(:lockAtMostForInterval as interval), timezone('utc', CURRENT_TIMESTAMP), :lockedBy) ON CONFLICT (" + this.name() + ") DO UPDATE" + this.updateClause();
    }

    @NonNull
    private String updateClause() {
        return " SET " + this.lockUntil() + " = timezone('utc', CURRENT_TIMESTAMP) + cast(:lockAtMostForInterval as interval), " + this.lockedAt() + " = timezone('utc', CURRENT_TIMESTAMP), " + this.lockedBy() + " = :lockedBy WHERE " + this.tableName() + "." + this.name() + " = :name AND " + this.tableName() + "." + this.lockUntil() + " <= timezone('utc', CURRENT_TIMESTAMP)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + this.updateClause();
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = this.lockedAt() + " + cast(:lockAtLeastForInterval as interval)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > timezone('utc', CURRENT_TIMESTAMP) THEN " + lockAtLeastFor + " ELSE timezone('utc', CURRENT_TIMESTAMP) END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = timezone('utc', CURRENT_TIMESTAMP) + cast(:lockAtMostForInterval as interval) WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > timezone('utc', CURRENT_TIMESTAMP)";
    }

    @Override
    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockedBy", this.configuration.getLockedByValue(), "lockAtMostForInterval", lockConfiguration.getLockAtMostFor().toMillis() + " milliseconds", "lockAtLeastForInterval", lockConfiguration.getLockAtLeastFor().toMillis() + " milliseconds");
    }
}

