/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.Db2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.H2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.HsqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.MsSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.MySqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.OracleServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlStatementsSource {
    protected final JdbcTemplateLockProvider.Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SqlStatementsSource.class);

    SqlStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = configuration;
    }

    static SqlStatementsSource create(JdbcTemplateLockProvider.Configuration configuration) {
        String databaseProductName = SqlStatementsSource.getDatabaseProductName(configuration);
        if (configuration.getUseDbTime()) {
            switch (databaseProductName) {
                case "PostgreSQL": {
                    logger.debug("Using PostgresSqlServerTimeStatementsSource");
                    return new PostgresSqlServerTimeStatementsSource(configuration);
                }
                case "Microsoft SQL Server": {
                    logger.debug("Using MsSqlServerTimeStatementsSource");
                    return new MsSqlServerTimeStatementsSource(configuration);
                }
                case "Oracle": {
                    logger.debug("Using OracleServerTimeStatementsSource");
                    return new OracleServerTimeStatementsSource(configuration);
                }
                case "MySQL": {
                    logger.debug("Using MySqlServerTimeStatementsSource");
                    return new MySqlServerTimeStatementsSource(configuration);
                }
                case "MariaDB": {
                    logger.debug("Using MySqlServerTimeStatementsSource (for MariaDB)");
                    return new MySqlServerTimeStatementsSource(configuration);
                }
                case "HSQL Database Engine": {
                    logger.debug("Using HsqlServerTimeStatementsSource");
                    return new HsqlServerTimeStatementsSource(configuration);
                }
                case "H2": {
                    logger.debug("Using H2ServerTimeStatementsSource");
                    return new H2ServerTimeStatementsSource(configuration);
                }
            }
            if (databaseProductName.startsWith("DB2")) {
                logger.debug("Using Db2ServerTimeStatementsSource");
                return new Db2ServerTimeStatementsSource(configuration);
            }
            throw new UnsupportedOperationException("DB time is not supported for '" + databaseProductName + "'");
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            logger.debug("Using PostgresSqlServerTimeStatementsSource");
            return new PostgresSqlStatementsSource(configuration);
        }
        logger.debug("Using SqlStatementsSource");
        return new SqlStatementsSource(configuration);
    }

    private static String getDatabaseProductName(JdbcTemplateLockProvider.Configuration configuration) {
        try {
            return (String)configuration.getJdbcTemplate().execute(connection -> connection.getMetaData().getDatabaseProductName());
        }
        catch (Exception e) {
            logger.debug("Can not determine database product name " + e.getMessage());
            return "Unknown";
        }
    }

    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockUntil", this.timestamp(lockConfiguration.getLockAtMostUntil()), "now", this.timestamp(ClockProvider.now()), "lockedBy", this.configuration.getLockedByValue(), "unlockTime", this.timestamp(lockConfiguration.getUnlockTime()));
    }

    @NonNull
    private Object timestamp(Instant time) {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone == null) {
            return Timestamp.from(time);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(time));
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, :lockUntil, :now, :lockedBy)";
    }

    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil, " + this.lockedAt() + " = :now, " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= :now";
    }

    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > :now";
    }

    public String getUnlockStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :unlockTime WHERE " + this.name() + " = :name";
    }

    String name() {
        return this.configuration.getColumnNames().getName();
    }

    String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    String tableName() {
        return this.configuration.getTableName();
    }
}

