/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Objects;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateStorageAccessor;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateLockProvider
extends StorageBasedLockProvider {
    public JdbcTemplateLockProvider(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, (PlatformTransactionManager)null);
    }

    public JdbcTemplateLockProvider(JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager) {
        this(jdbcTemplate, transactionManager, "shedlock");
    }

    public JdbcTemplateLockProvider(JdbcTemplate jdbcTemplate, String tableName) {
        this(jdbcTemplate, null, tableName);
    }

    public JdbcTemplateLockProvider(DataSource dataSource) {
        this(new JdbcTemplate(dataSource));
    }

    public JdbcTemplateLockProvider(DataSource dataSource, String tableName) {
        this(new JdbcTemplate(dataSource), tableName);
    }

    public JdbcTemplateLockProvider(JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager, String tableName) {
        this(((Configuration.Builder)Configuration.builder().withJdbcTemplate(jdbcTemplate).withTransactionManager(transactionManager).withTableName(tableName)).build());
    }

    public JdbcTemplateLockProvider(Configuration configuration) {
        super((StorageAccessor)new JdbcTemplateStorageAccessor(configuration));
    }

    public static final class Configuration
    extends SqlConfiguration {
        private final JdbcTemplate jdbcTemplate;
        private final @Nullable PlatformTransactionManager transactionManager;
        private final @Nullable Integer isolationLevel;
        private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

        Configuration(JdbcTemplate jdbcTemplate, @Nullable DatabaseProduct databaseProduct, boolean dbUpperCase, @Nullable PlatformTransactionManager transactionManager, String tableName, @Nullable TimeZone timeZone, SqlConfiguration.ColumnNames columnNames, String lockedByValue, boolean useDbTime, @Nullable Integer isolationLevel) {
            super(databaseProduct, dbUpperCase, tableName, timeZone, columnNames, lockedByValue, useDbTime);
            this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
            this.transactionManager = transactionManager;
            this.isolationLevel = isolationLevel;
        }

        public JdbcTemplate getJdbcTemplate() {
            return this.jdbcTemplate;
        }

        public @Nullable PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public @Nullable Integer getIsolationLevel() {
            return this.isolationLevel;
        }

        public DatabaseProduct getDatabaseProduct() {
            if (super.getDatabaseProduct() != null) {
                return super.getDatabaseProduct();
            }
            try {
                String jdbcProductName = (String)this.getJdbcTemplate().execute(connection -> connection.getMetaData().getDatabaseProductName());
                return DatabaseProduct.matchProductName((String)jdbcProductName);
            }
            catch (Exception e) {
                logger.debug("Can not determine database product name {}", (Object)e.getMessage());
                return DatabaseProduct.UNKNOWN;
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends SqlConfiguration.SqlConfigurationBuilder<Builder> {
            private @Nullable JdbcTemplate jdbcTemplate;
            private @Nullable PlatformTransactionManager transactionManager;
            private @Nullable TimeZone timeZone;
            private @Nullable Integer isolationLevel;

            public Builder withJdbcTemplate(JdbcTemplate jdbcTemplate) {
                this.jdbcTemplate = jdbcTemplate;
                return this;
            }

            public Builder withTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
                this.transactionManager = transactionManager;
                return this;
            }

            @Deprecated(forRemoval=true)
            public Builder withTimeZone(TimeZone timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public Builder forceUtcTimeZone() {
                this.timeZone = TimeZone.getTimeZone("UTC");
                return this;
            }

            public Builder withIsolationLevel(int isolationLevel) {
                this.isolationLevel = isolationLevel;
                return (Builder)this.getThis();
            }

            public Configuration build() {
                return new Configuration(Objects.requireNonNull(this.jdbcTemplate, "jdbcTemplate can not be null"), this.databaseProduct, this.dbUpperCase, this.transactionManager, this.tableName, this.timeZone, this.columnNames, this.lockedByValue, this.useDbTime, this.isolationLevel);
            }
        }
    }

    public static final class ColumnNames
    extends SqlConfiguration.ColumnNames {
        public ColumnNames(String name, String lockUntil, String lockedAt, String lockedBy) {
            super(name, lockUntil, lockedAt, lockedBy);
        }
    }
}

