package net.javacrumbs.shedlock.provider.jooq;


import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

import java.time.LocalDateTime;


/**
 * This class is generated by jOOQ.
 */
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
class Shedlock extends TableImpl<Record> {

    private static final long serialVersionUID = 1L;

    /**
     * The reference instance of <code>public.shedlock</code>
     */
    public static final Shedlock SHEDLOCK = new Shedlock();

    public static final UniqueKey<Record> SHEDLOCK_PKEY = Internal.createUniqueKey(Shedlock.SHEDLOCK, DSL.name("shedlock_pkey"), new TableField[] { Shedlock.SHEDLOCK.NAME }, true);


    /**
     * The class holding records for this type
     */
    @Override
    public Class<Record> getRecordType() {
        return Record.class;
    }

    /**
     * The column <code>public.shedlock.name</code>.
     */
    public final TableField<Record, String> NAME = createField(DSL.name("name"), SQLDataType.VARCHAR(64).nullable(false), this, "");

    /**
     * The column <code>public.shedlock.lock_until</code>.
     */
    public final TableField<Record, LocalDateTime> LOCK_UNTIL = createField(DSL.name("lock_until"), SQLDataType.LOCALDATETIME(6).nullable(false), this, "");

    /**
     * The column <code>public.shedlock.locked_at</code>.
     */
    public final TableField<Record, LocalDateTime> LOCKED_AT = createField(DSL.name("locked_at"), SQLDataType.LOCALDATETIME(6).nullable(false), this, "");

    /**
     * The column <code>public.shedlock.locked_by</code>.
     */
    public final TableField<Record, String> LOCKED_BY = createField(DSL.name("locked_by"), SQLDataType.VARCHAR(255).nullable(false), this, "");

    private Shedlock(Name alias, Table<Record> aliased) {
        this(alias, aliased, null);
    }

    private Shedlock(Name alias, Table<Record> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table());
    }

    /**
     * Create an aliased <code>public.shedlock</code> table reference
     */
    public Shedlock(String alias) {
        this(DSL.name(alias), SHEDLOCK);
    }

    /**
     * Create an aliased <code>public.shedlock</code> table reference
     */
    public Shedlock(Name alias) {
        this(alias, SHEDLOCK);
    }

    /**
     * Create a <code>public.shedlock</code> table reference
     */
    public Shedlock() {
        this(DSL.name("shedlock"), null);
    }

    public <O extends Record> Shedlock(Table<O> child, ForeignKey<O, Record> key) {
        super(child, key, SHEDLOCK);
    }


    @Override
    public Shedlock as(String alias) {
        return new Shedlock(DSL.name(alias), this);
    }

    @Override
    public Shedlock as(Name alias) {
        return new Shedlock(alias, this);
    }

    @Override
    public Shedlock as(Table<?> alias) {
        return new Shedlock(alias.getQualifiedName(), this);
    }
    @Override
    public UniqueKey<Record> getPrimaryKey() {
        return SHEDLOCK_PKEY;
    }

    /**
     * Rename this table
     */
    @Override
    public Shedlock rename(String name) {
        return new Shedlock(DSL.name(name), null);
    }

    /**
     * Rename this table
     */
    @Override
    public Shedlock rename(Name name) {
        return new Shedlock(name, null);
    }

    /**
     * Rename this table
     */
    @Override
    public Shedlock rename(Table<?> name) {
        return new Shedlock(name.getQualifiedName(), null);
    }
}


