/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo.reactivestreams;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SingleLockableSubscriber<T>
implements Subscriber<T> {
    private T value;
    private Throwable error;
    private final CountDownLatch latch = new CountDownLatch(1);

    SingleLockableSubscriber() {
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(1L);
    }

    public void onNext(T document) {
        this.value = document;
    }

    public void onError(Throwable throwable) {
        this.error = throwable;
        this.onComplete();
    }

    public void onComplete() {
        this.latch.countDown();
    }

    T getValue() {
        return this.value;
    }

    Throwable getError() {
        return this.error;
    }

    void await() {
        try {
            this.latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.error = e;
        }
    }
}

