/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo.reactivestreams;

import com.mongodb.MongoServerException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.mongo.reactivestreams.SingleLockableSubscriber;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public class ReactiveStreamsMongoLockProvider
implements ExtensibleLockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    static final String DEFAULT_SHEDLOCK_COLLECTION_NAME = "shedLock";
    private final String hostname;
    private final MongoCollection<Document> collection;

    public ReactiveStreamsMongoLockProvider(MongoDatabase mongoDatabase) {
        this((MongoCollection<Document>)mongoDatabase.getCollection(DEFAULT_SHEDLOCK_COLLECTION_NAME));
    }

    public ReactiveStreamsMongoLockProvider(MongoCollection<Document> collection) {
        this.collection = collection;
        this.hostname = Utils.getHostname();
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Instant now = this.now();
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getLockAtMostUntil()), Updates.set((String)LOCKED_AT, (Object)now), Updates.set((String)LOCKED_BY, (Object)this.hostname)});
        try {
            ReactiveStreamsMongoLockProvider.execute(this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)lockConfiguration.getName()), Filters.lte((String)LOCK_UNTIL, (Object)now)}), update, new FindOneAndUpdateOptions().upsert(true)));
            return Optional.of(new ReactiveMongoLock(lockConfiguration, this));
        }
        catch (MongoServerException e) {
            if (e.getCode() == 11000) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private Optional<SimpleLock> extend(LockConfiguration lockConfiguration) {
        Instant now = this.now();
        Bson update = Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getLockAtMostUntil());
        Document updatedDocument = (Document)ReactiveStreamsMongoLockProvider.execute(this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)lockConfiguration.getName()), Filters.gt((String)LOCK_UNTIL, (Object)now), Filters.eq((String)LOCKED_BY, (Object)this.hostname)}), update));
        if (updatedDocument != null) {
            return Optional.of(new ReactiveMongoLock(lockConfiguration, this));
        }
        return Optional.empty();
    }

    private void unlock(LockConfiguration lockConfiguration) {
        ReactiveStreamsMongoLockProvider.execute(this.getCollection().findOneAndUpdate(Filters.eq((String)ID, (Object)lockConfiguration.getName()), Updates.combine((Bson[])new Bson[]{Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getUnlockTime())})));
    }

    static <T> T execute(Publisher<T> command) {
        SingleLockableSubscriber subscriber = new SingleLockableSubscriber();
        command.subscribe(subscriber);
        subscriber.await();
        Throwable error = subscriber.getError();
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new LockException("Error when executing Mongo statement", error);
        }
        return subscriber.getValue();
    }

    private MongoCollection<Document> getCollection() {
        return this.collection;
    }

    private Instant now() {
        return ClockProvider.now();
    }

    private static final class ReactiveMongoLock
    extends AbstractSimpleLock {
        private final ReactiveStreamsMongoLockProvider mongoLockProvider;

        private ReactiveMongoLock(LockConfiguration lockConfiguration, ReactiveStreamsMongoLockProvider mongoLockProvider) {
            super(lockConfiguration);
            this.mongoLockProvider = mongoLockProvider;
        }

        public void doUnlock() {
            this.mongoLockProvider.unlock(this.lockConfiguration);
        }

        public Optional<SimpleLock> doExtend(LockConfiguration newLockConfiguration) {
            return this.mongoLockProvider.extend(newLockConfiguration);
        }
    }
}

