/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo.reactivestreams;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.javacrumbs.shedlock.support.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SingleLockableSubscriber<T>
implements Subscriber<T> {
    @Nullable
    private T value;
    @Nullable
    private Throwable error;
    private final CountDownLatch latch = new CountDownLatch(1);

    SingleLockableSubscriber() {
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(1L);
    }

    public void onNext(T document) {
        this.value = document;
    }

    public void onError(Throwable throwable) {
        this.error = throwable;
        this.onComplete();
    }

    public void onComplete() {
        this.latch.countDown();
    }

    @Nullable
    T getValue() {
        return this.value;
    }

    @Nullable
    Throwable getError() {
        return this.error;
    }

    void await() {
        try {
            int timeout = 20;
            if (!this.latch.await(timeout, TimeUnit.SECONDS)) {
                this.error = new TimeoutException("Did not get response in " + timeout + " seconds.");
            }
        }
        catch (InterruptedException e) {
            this.error = e;
        }
    }
}

