/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoServerException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    static final String DEFAULT_SHEDLOCK_COLLECTION_NAME = "shedLock";
    private final String hostname;
    private final MongoCollection<Document> collection;

    @Deprecated
    public MongoLockProvider(@NonNull MongoClient mongo, @NonNull String databaseName) {
        this(mongo, databaseName, DEFAULT_SHEDLOCK_COLLECTION_NAME);
    }

    @Deprecated
    public MongoLockProvider(@NonNull MongoClient mongo, @NonNull String databaseName, @NonNull String collectionName) {
        this((MongoCollection<Document>)mongo.getDatabase(databaseName).getCollection(collectionName));
    }

    public MongoLockProvider(@NonNull MongoDatabase mongoDatabase) {
        this((MongoCollection<Document>)mongoDatabase.getCollection(DEFAULT_SHEDLOCK_COLLECTION_NAME));
    }

    public MongoLockProvider(@NonNull MongoCollection<Document> collection) {
        this.collection = collection;
        this.hostname = Utils.getHostname();
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        Instant now = this.now();
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getLockAtMostUntil()), Updates.set((String)LOCKED_AT, (Object)now), Updates.set((String)LOCKED_BY, (Object)this.hostname)});
        try {
            this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)lockConfiguration.getName()), Filters.lte((String)LOCK_UNTIL, (Object)now)}), update, new FindOneAndUpdateOptions().upsert(true));
            return Optional.of(new MongoLock(lockConfiguration, this));
        }
        catch (MongoServerException e) {
            if (e.getCode() == 11000) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private Optional<SimpleLock> extend(LockConfiguration lockConfiguration) {
        Instant now = this.now();
        Bson update = Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getLockAtMostUntil());
        Document updatedDocument = (Document)this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)lockConfiguration.getName()), Filters.gt((String)LOCK_UNTIL, (Object)now), Filters.eq((String)LOCKED_BY, (Object)this.hostname)}), update);
        if (updatedDocument != null) {
            return Optional.of(new MongoLock(lockConfiguration, this));
        }
        return Optional.empty();
    }

    private void unlock(LockConfiguration lockConfiguration) {
        this.getCollection().findOneAndUpdate(Filters.eq((String)ID, (Object)lockConfiguration.getName()), Updates.combine((Bson[])new Bson[]{Updates.set((String)LOCK_UNTIL, (Object)lockConfiguration.getUnlockTime())}));
    }

    private MongoCollection<Document> getCollection() {
        return this.collection;
    }

    private Instant now() {
        return ClockProvider.now();
    }

    private static final class MongoLock
    extends AbstractSimpleLock {
        private final MongoLockProvider mongoLockProvider;

        private MongoLock(LockConfiguration lockConfiguration, MongoLockProvider mongoLockProvider) {
            super(lockConfiguration);
            this.mongoLockProvider = mongoLockProvider;
        }

        public void doUnlock() {
            this.mongoLockProvider.unlock(this.lockConfiguration);
        }

        public Optional<SimpleLock> doExtend(LockConfiguration newLockConfiguration) {
            return this.mongoLockProvider.extend(newLockConfiguration);
        }
    }
}

