/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.Statement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.function.Function;
import net.javacrumbs.shedlock.support.annotation.NonNull;

abstract class R2dbcAdapter {
    private static final String MSSQL_NAME = "Microsoft SQL Server";
    private static final String MYSQL_NAME = "MySQL";
    private static final String MARIA_NAME = "MariaDB";
    private static final String ORACLE_NAME = "Oracle Database";

    R2dbcAdapter() {
    }

    static R2dbcAdapter create(@NonNull String driver) {
        switch (driver) {
            case "Microsoft SQL Server": {
                return new DefaultR2dbcAdapter((index, name) -> "@" + name, R2dbcAdapter::toLocalDate, R2dbcAdapter::bindByName);
            }
            case "MySQL": 
            case "MariaDB": {
                return new DefaultR2dbcAdapter((index, name) -> "?", R2dbcAdapter::toLocalDate, R2dbcAdapter::bindByIndex);
            }
            case "Oracle Database": {
                return new DefaultR2dbcAdapter((index, name) -> ":" + name, R2dbcAdapter::toLocalDate, R2dbcAdapter::bindByName);
            }
        }
        return new DefaultR2dbcAdapter((index, name) -> "$" + index, R2dbcAdapter::toInstant, R2dbcAdapter::bindByIndex);
    }

    private static Instant toInstant(Instant date) {
        return date;
    }

    private static LocalDateTime toLocalDate(Instant date) {
        return LocalDateTime.ofInstant(date, ZoneId.systemDefault());
    }

    private static void bindByName(Statement statement, int index, String name, Object value) {
        statement.bind(name, value);
    }

    private static void bindByIndex(Statement statement, int index, String name, Object value) {
        statement.bind(index, value);
    }

    protected abstract String toParameter(int var1, String var2);

    public abstract void bind(Statement var1, int var2, String var3, Object var4);

    private static class DefaultR2dbcAdapter
    extends R2dbcAdapter {
        private final ParameterResolver parameterResolver;
        private final Function<Instant, Object> dateConverter;
        private final ValueBinder binder;

        private DefaultR2dbcAdapter(@NonNull ParameterResolver parameterResolver, @NonNull Function<Instant, Object> dateConverter, @NonNull ValueBinder binder) {
            this.parameterResolver = parameterResolver;
            this.dateConverter = dateConverter;
            this.binder = binder;
        }

        @Override
        protected String toParameter(int index, String name) {
            return this.parameterResolver.resolve(index, name);
        }

        @Override
        public void bind(Statement statement, int index, String name, Object value) {
            this.binder.bind(statement, index, name, this.normalizeValue(value));
        }

        private Object normalizeValue(Object value) {
            if (value instanceof Instant) {
                return this.dateConverter.apply((Instant)value);
            }
            return value;
        }
    }

    @FunctionalInterface
    private static interface ParameterResolver {
        public String resolve(int var1, String var2);
    }

    @FunctionalInterface
    private static interface ValueBinder {
        public void bind(Statement var1, int var2, String var3, Object var4);
    }
}

