/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Statement;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.javacrumbs.shedlock.provider.r2dbc.AbstractR2dbcStorageAccessor;
import net.javacrumbs.shedlock.provider.r2dbc.R2dbcAdapter;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class R2dbcStorageAccessor
extends AbstractR2dbcStorageAccessor {
    private final ConnectionFactory connectionFactory;
    private R2dbcAdapter adapter;

    R2dbcStorageAccessor(@NonNull ConnectionFactory connectionFactory, @NonNull String tableName) {
        super(tableName);
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "dataSource can not be null");
    }

    @Override
    protected <T> Mono<T> executeCommand(String sql, Function<Statement, Mono<T>> body, BiFunction<String, Throwable, Mono<T>> exceptionHandler) {
        return Mono.usingWhen((Publisher)Mono.from((Publisher)this.connectionFactory.create()).doOnNext(it -> it.setAutoCommit(true)), conn -> ((Mono)body.apply(conn.createStatement(sql))).onErrorResume(throwable -> (Mono)exceptionHandler.apply(sql, (Throwable)throwable)), Connection::close, (connection, throwable) -> Mono.from((Publisher)connection.close()).then((Mono)exceptionHandler.apply(sql, (Throwable)throwable)), connection -> Mono.from((Publisher)connection.close()).then());
    }

    @Override
    protected String toParameter(int index, String name) {
        return this.getAdapter().toParameter(index, name);
    }

    @Override
    protected void bind(Statement statement, int index, String name, Object value) {
        this.getAdapter().bind(statement, index, name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R2dbcAdapter getAdapter() {
        R2dbcStorageAccessor r2dbcStorageAccessor = this;
        synchronized (r2dbcStorageAccessor) {
            if (this.adapter == null) {
                this.adapter = R2dbcAdapter.create(this.connectionFactory.getMetadata().getName());
            }
            return this.adapter;
        }
    }
}

