/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.r2dbc.R2dbcAdapter;
import net.javacrumbs.shedlock.provider.r2dbc.R2dbcLockProvider;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class R2dbcStorageAccessor
extends AbstractStorageAccessor {
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile(":[a-zA-Z]+");
    private final ConnectionFactory connectionFactory;
    private final SqlStatementsSource sqlStatementsSource;
    private final R2dbcAdapter adapter;

    R2dbcStorageAccessor(R2dbcLockProvider.Configuration configuration) {
        this.connectionFactory = configuration.getConnectionFactory();
        this.sqlStatementsSource = SqlStatementsSource.create((SqlConfiguration)configuration);
        this.adapter = R2dbcAdapter.create(configuration.getDatabaseProduct());
    }

    protected String toParameter(int index, String name) {
        return this.adapter.toParameter(index, name);
    }

    protected void bind(Statement statement, int index, String name, Object value) {
        this.adapter.bind(statement, index, name, value);
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.block(this.insertRecordReactive(lockConfiguration)));
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.block(this.updateRecordReactive(lockConfiguration)));
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.block(this.extendReactive(lockConfiguration)));
    }

    public void unlock(LockConfiguration lockConfiguration) {
        this.block(this.unlockReactive(lockConfiguration));
    }

    private <T> @Nullable T block(Mono<T> mono) {
        try {
            return (T)mono.block(Duration.ofSeconds(30L));
        }
        catch (Exception e) {
            if (e instanceof LockException) {
                LockException lockException = (LockException)e;
                throw lockException;
            }
            throw new LockException("Unexpected exception when executing r2dbc operation", (Throwable)e);
        }
    }

    Mono<Boolean> insertRecordReactive(LockConfiguration lockConfiguration) {
        SqlStatement sqlStatement = this.translate(this.sqlStatementsSource.getInsertStatement(), this.sqlStatementsSource.params(lockConfiguration));
        return this.executeCommand(sqlStatement, this::handleInsertionException);
    }

    Mono<Boolean> updateRecordReactive(LockConfiguration lockConfiguration) {
        SqlStatement sqlStatement = this.translate(this.sqlStatementsSource.getUpdateStatement(), this.sqlStatementsSource.params(lockConfiguration));
        return this.executeCommand(sqlStatement, this::handleUpdateException);
    }

    Mono<Boolean> extendReactive(LockConfiguration lockConfiguration) {
        SqlStatement sqlStatement = this.translate(this.sqlStatementsSource.getExtendStatement(), this.sqlStatementsSource.params(lockConfiguration));
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.executeCommand(sqlStatement, this::handleUnlockException);
    }

    Mono<Boolean> unlockReactive(LockConfiguration lockConfiguration) {
        SqlStatement sqlStatement = this.translate(this.sqlStatementsSource.getUnlockStatement(), this.sqlStatementsSource.params(lockConfiguration));
        return this.executeCommand(sqlStatement, this::handleUnlockException);
    }

    private Mono<Boolean> executeCommand(SqlStatement sqlStatement, BiFunction<String, Throwable, Mono<Boolean>> exceptionHandler) {
        return Mono.usingWhen((Publisher)Mono.from((Publisher)this.connectionFactory.create()).doOnNext(it -> it.setAutoCommit(true)), conn -> {
            Statement statement = conn.createStatement(sqlStatement.sql);
            for (int i = 0; i < sqlStatement.parameters.size(); ++i) {
                SqlParam param = sqlStatement.parameters.get(i);
                this.bind(statement, i, param.name(), param.value());
            }
            return Mono.from((Publisher)statement.execute()).flatMap(it -> Mono.from((Publisher)it.getRowsUpdated())).map(it -> it > 0L).onErrorResume(throwable -> (Mono)exceptionHandler.apply(sqlStatement.sql, (Throwable)throwable));
        }, Connection::close, (connection, throwable) -> Mono.from((Publisher)connection.close()), connection -> Mono.from((Publisher)connection.close()).then());
    }

    Mono<Boolean> handleInsertionException(String sql, Throwable e) {
        if (e instanceof R2dbcDataIntegrityViolationException) {
            return Mono.just((Object)false);
        }
        return Mono.error((Throwable)new LockException("Unexpected exception when locking", e));
    }

    private SqlStatement translate(String statement, Map<String, Object> namedParameters) {
        ArrayList<SqlParam> parameters = new ArrayList<SqlParam>();
        AtomicInteger index = new AtomicInteger(1);
        String translatedSql = NAMED_PARAMETER_PATTERN.matcher(statement).replaceAll(result -> {
            String key = result.group().substring(1);
            if (!namedParameters.containsKey(key)) {
                throw new IllegalStateException("Parameter " + key + " not found");
            }
            parameters.add(new SqlParam(key, namedParameters.get(key)));
            return Matcher.quoteReplacement(this.toParameter(index.getAndIncrement(), key));
        });
        return new SqlStatement(translatedSql, parameters);
    }

    Mono<Boolean> handleUpdateException(String sql, Throwable e) {
        return Mono.error((Throwable)new LockException("Unexpected exception when locking", e));
    }

    Mono<Boolean> handleUnlockException(String sql, Throwable e) {
        return Mono.error((Throwable)new LockException("Unexpected exception when unlocking", e));
    }

    private record SqlStatement(String sql, List<SqlParam> parameters) {
    }

    private record SqlParam(String name, Object value) {
    }
}

