/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockProvider
implements ExtensibleLockProvider {
    private static final String KEY_PREFIX_DEFAULT = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final StringRedisTemplate redisTemplate;
    private final String environment;
    private final String keyPrefix;

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn) {
        this(redisConn, ENV_DEFAULT);
    }

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn, @NonNull String environment) {
        this(redisConn, environment, KEY_PREFIX_DEFAULT);
    }

    public RedisLockProvider(@NonNull RedisConnectionFactory redisConn, @NonNull String environment, @NonNull String keyPrefix) {
        this(new StringRedisTemplate(redisConn), environment, keyPrefix);
    }

    public RedisLockProvider(@NonNull StringRedisTemplate redisTemplate, @NonNull String environment, @NonNull String keyPrefix) {
        this.redisTemplate = redisTemplate;
        this.environment = environment;
        this.keyPrefix = keyPrefix;
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        Expiration expiration;
        String key = this.buildKey(lockConfiguration.getName());
        if (Boolean.TRUE.equals(RedisLockProvider.tryToSetExpiration(this.redisTemplate, key, expiration = RedisLockProvider.getExpiration(lockConfiguration.getLockAtMostUntil()), RedisStringCommands.SetOption.SET_IF_ABSENT))) {
            return Optional.of(new RedisLock(key, this.redisTemplate, lockConfiguration));
        }
        return Optional.empty();
    }

    private static Expiration getExpiration(Instant until) {
        return Expiration.from((long)RedisLockProvider.getMsUntil(until), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static long getMsUntil(Instant until) {
        return Duration.between(ClockProvider.now(), until).toMillis();
    }

    String buildKey(String lockName) {
        return String.format("%s:%s:%s", this.keyPrefix, this.environment, lockName);
    }

    private static Boolean tryToSetExpiration(StringRedisTemplate template, String key, Expiration expiration, RedisStringCommands.SetOption option) {
        return (Boolean)template.execute(connection -> {
            byte[] serializedKey = template.getKeySerializer().serialize((Object)key);
            byte[] serializedValue = template.getValueSerializer().serialize((Object)String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname()));
            return connection.set(serializedKey, serializedValue, expiration, option);
        }, false);
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final StringRedisTemplate redisTemplate;

        private RedisLock(String key, StringRedisTemplate redisTemplate, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.redisTemplate = redisTemplate;
        }

        public void doUnlock() {
            Expiration keepLockFor = RedisLockProvider.getExpiration(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor.getExpirationTimeInMilliseconds() <= 0L) {
                try {
                    this.redisTemplate.delete((Object)this.key);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                RedisLockProvider.tryToSetExpiration(this.redisTemplate, this.key, keepLockFor, RedisStringCommands.SetOption.SET_IF_PRESENT);
            }
        }

        public Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
            Expiration expiration = RedisLockProvider.getExpiration(newConfiguration.getLockAtMostUntil());
            if (Boolean.TRUE.equals(RedisLockProvider.tryToSetExpiration(this.redisTemplate, this.key, expiration, RedisStringCommands.SetOption.SET_IF_PRESENT))) {
                return Optional.of(new RedisLock(this.key, this.redisTemplate, newConfiguration));
            }
            return Optional.empty();
        }
    }

    public static class Builder {
        private final StringRedisTemplate redisTemplate;
        private String environment = "default";
        private String keyPrefix = "job-lock";

        public Builder(@NonNull RedisConnectionFactory redisConnectionFactory) {
            this.redisTemplate = new StringRedisTemplate(redisConnectionFactory);
        }

        public Builder(@NonNull StringRedisTemplate redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public Builder environment(@NonNull String environment) {
            this.environment = environment;
            return this;
        }

        public Builder keyPrefix(@NonNull String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public RedisLockProvider build() {
            return new RedisLockProvider(this.redisTemplate, this.environment, this.keyPrefix);
        }
    }
}

