/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.javacrumbs.shedlock.core.DefaultLockManager;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.spring.LockableTaskScheduler;
import net.javacrumbs.shedlock.spring.ScheduledLockConfiguration;
import net.javacrumbs.shedlock.spring.SpringLockConfigurationExtractor;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.StringValueResolver;

public class SpringLockableTaskSchedulerFactoryBean
extends AbstractFactoryBean<LockableTaskScheduler>
implements EmbeddedValueResolverAware,
ScheduledLockConfiguration {
    private final TaskScheduler taskScheduler;
    private final LockProvider lockProvider;
    private final TemporalAmount defaultLockAtMostFor;
    private final TemporalAmount defaultLockAtLeastFor;
    private StringValueResolver embeddedValueResolver;

    public SpringLockableTaskSchedulerFactoryBean(TaskScheduler taskScheduler, LockProvider lockProvider, TemporalAmount defaultLockAtMostFor) {
        this(taskScheduler, lockProvider, defaultLockAtMostFor, Duration.ZERO);
    }

    public SpringLockableTaskSchedulerFactoryBean(TaskScheduler taskScheduler, LockProvider lockProvider, TemporalAmount defaultLockAtMostFor, TemporalAmount defaultLockAtLeastFor) {
        this.taskScheduler = taskScheduler;
        this.lockProvider = lockProvider;
        this.defaultLockAtMostFor = defaultLockAtMostFor;
        this.defaultLockAtLeastFor = defaultLockAtLeastFor;
    }

    public Class<?> getObjectType() {
        return LockableTaskScheduler.class;
    }

    protected LockableTaskScheduler createInstance() {
        return new LockableTaskScheduler(this.taskScheduler, (LockManager)new DefaultLockManager(this.lockProvider, (LockConfigurationExtractor)new SpringLockConfigurationExtractor(this.defaultLockAtMostFor, this.defaultLockAtLeastFor, this.embeddedValueResolver)));
    }

    protected void destroyInstance(LockableTaskScheduler instance) throws Exception {
        instance.destroy();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }
}

