/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.annotation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

class RegisterDefaultTaskSchedulerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private static final Logger logger = LoggerFactory.getLogger(RegisterDefaultTaskSchedulerPostProcessor.class);

    RegisterDefaultTaskSchedulerPostProcessor() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), TaskScheduler.class).length == 0) {
            logger.debug("Registering default TaskScheduler");
            registry.registerBeanDefinition("taskScheduler", (BeanDefinition)new RootBeanDefinition(ConcurrentTaskScheduler.class));
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

