/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

class RegisterDefaultTaskSchedulerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered,
BeanFactoryAware {
    private @Nullable BeanFactory beanFactory;
    private static final Logger logger = LoggerFactory.getLogger(RegisterDefaultTaskSchedulerPostProcessor.class);

    RegisterDefaultTaskSchedulerPostProcessor() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanFactory beanFactory = Objects.requireNonNull(this.beanFactory, "BeanFactory not set");
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)beanFactory;
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)listableBeanFactory, TaskScheduler.class).length == 0) {
            String[] scheduledExecutorsBeanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)listableBeanFactory, ScheduledExecutorService.class);
            if (scheduledExecutorsBeanNames.length != 1) {
                logger.debug("Registering default TaskScheduler");
                registry.registerBeanDefinition("taskScheduler", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ConcurrentTaskScheduler.class).getBeanDefinition());
                if (scheduledExecutorsBeanNames.length != 0) {
                    logger.warn("Multiple ScheduledExecutorService found, do not know which one to use.");
                }
            } else {
                logger.debug("Registering default TaskScheduler with existing ScheduledExecutorService {}", (Object)scheduledExecutorsBeanNames[0]);
                registry.registerBeanDefinition("taskScheduler", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ConcurrentTaskScheduler.class).addPropertyReference("scheduledExecutor", scheduledExecutorsBeanNames[0]).getBeanDefinition());
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

