/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

class StringToDurationConverter
implements Converter<String, Duration> {
    static final StringToDurationConverter INSTANCE = new StringToDurationConverter();
    private static final Pattern ISO8601 = Pattern.compile("^[\\+\\-]?P.*$");
    private static final Pattern SIMPLE = Pattern.compile("^([\\+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private static final Map<String, ChronoUnit> UNITS;

    StringToDurationConverter() {
    }

    public Duration convert(String source) {
        try {
            if (ISO8601.matcher(source).matches()) {
                return Duration.parse(source);
            }
            Matcher matcher = SIMPLE.matcher(source);
            Assert.state((boolean)matcher.matches(), (String)("'" + source + "' is not a valid duration"));
            long amount = Long.parseLong(matcher.group(1));
            ChronoUnit unit = this.getUnit(matcher.group(2));
            return Duration.of(amount, unit);
        }
        catch (Exception ex) {
            throw new IllegalStateException("'" + source + "' is not a valid duration", ex);
        }
    }

    private ChronoUnit getUnit(String value) {
        ChronoUnit unit = UNITS.get(value.toLowerCase(Locale.ROOT));
        return Objects.requireNonNull(unit, "Unknown unit '" + value + "'");
    }

    static {
        LinkedHashMap<String, ChronoUnit> units = new LinkedHashMap<String, ChronoUnit>();
        units.put("us", ChronoUnit.MICROS);
        units.put("ns", ChronoUnit.NANOS);
        units.put("ms", ChronoUnit.MILLIS);
        units.put("s", ChronoUnit.SECONDS);
        units.put("m", ChronoUnit.MINUTES);
        units.put("h", ChronoUnit.HOURS);
        units.put("d", ChronoUnit.DAYS);
        units.put("", ChronoUnit.MILLIS);
        UNITS = Collections.unmodifiableMap(units);
    }
}

