/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.support;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockTemplate;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class InternalRedisLockProvider
implements ExtensibleLockProvider {
    public static final String DEFAULT_KEY_PREFIX = "job-lock";
    public static final String ENV_DEFAULT = "default";
    private final InternalRedisLockTemplate redisLockTemplate;
    private final String environment;
    private final String keyPrefix;
    private final boolean safeUpdate;
    private static final String delLuaScript = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then\n    return redis.call(\"del\",KEYS[1])\nelse\n    return 0\nend\n";
    private static final String updLuaScript = "if redis.call('get', KEYS[1]) == ARGV[1] then\n   return redis.call('pexpire', KEYS[1], ARGV[2])\nelse\n   return 0\nend\n";

    public InternalRedisLockProvider(@NonNull InternalRedisLockTemplate redisLockTemplate, @NonNull String environment, @NonNull String keyPrefix, boolean safeUpdate) {
        this.redisLockTemplate = redisLockTemplate;
        this.environment = environment;
        this.keyPrefix = keyPrefix;
        this.safeUpdate = safeUpdate;
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        String uniqueLockValue;
        long expireTime = InternalRedisLockProvider.getMsUntil(lockConfiguration.getLockAtMostUntil());
        String key = InternalRedisLockProvider.buildKey(lockConfiguration.getName(), this.keyPrefix, this.environment);
        if (this.createLock(key, uniqueLockValue = InternalRedisLockProvider.buildValue(), expireTime)) {
            return Optional.of(new RedisLock(key, uniqueLockValue, this, lockConfiguration));
        }
        return Optional.empty();
    }

    private Optional<SimpleLock> extend(RedisLock currentLock, LockConfiguration lockConfiguration) {
        long expireTime = InternalRedisLockProvider.getMsUntil(lockConfiguration.getLockAtMostUntil());
        if (this.setKeyExpiration(currentLock, expireTime)) {
            return Optional.of(new RedisLock(currentLock.key, currentLock.value, this, lockConfiguration));
        }
        return Optional.empty();
    }

    private boolean setKeyExpiration(RedisLock currentLock, long expiration) {
        if (this.safeUpdate) {
            return this.redisLockTemplate.eval(updLuaScript, currentLock.key, currentLock.value, String.valueOf(expiration)).equals(1L);
        }
        return this.redisLockTemplate.setIfPresent(currentLock.key, currentLock.value, expiration);
    }

    private boolean createLock(String key, String value, long expirationMs) {
        return this.redisLockTemplate.setIfAbsent(key, value, expirationMs);
    }

    private void deleteLock(String key, String value) {
        if (this.safeUpdate) {
            this.redisLockTemplate.eval(delLuaScript, key, value);
        } else {
            this.redisLockTemplate.delete(key);
        }
    }

    private static long getMsUntil(Instant instant) {
        return Duration.between(ClockProvider.now(), instant).toMillis();
    }

    private static String buildKey(String lockName, String keyPrefix, String env) {
        return String.format("%s:%s:%s", keyPrefix, env, lockName);
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s:%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname(), UUID.randomUUID());
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final String value;
        private final InternalRedisLockProvider lockProvider;

        private RedisLock(String key, String value, InternalRedisLockProvider lockProvider, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.value = value;
            this.lockProvider = lockProvider;
        }

        public void doUnlock() {
            long keepLockFor = InternalRedisLockProvider.getMsUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                try {
                    this.lockProvider.deleteLock(this.key, this.value);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                this.lockProvider.setKeyExpiration(this, keepLockFor);
            }
        }

        @NonNull
        protected Optional<SimpleLock> doExtend(@NonNull LockConfiguration newConfiguration) {
            return this.lockProvider.extend(this, newConfiguration);
        }
    }
}

