/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.Source;
import net.javacrumbs.smock.common.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.test.client.ResponseCreator;
import org.springframework.ws.test.server.RequestCreator;

public class MessageCreator
implements ResponseCreator,
RequestCreator {
    private final Source source;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public MessageCreator(Source sourceDocument) {
        this.source = sourceDocument;
    }

    protected final WebServiceMessage createMessage(URI uri, WebServiceMessage input, WebServiceMessageFactory messageFactory) throws IOException {
        WebServiceMessage result;
        Source source = this.preprocessSource(uri, input, messageFactory);
        if (XmlUtil.isSoap(source)) {
            result = messageFactory.createWebServiceMessage(XmlUtil.getSourceAsStream(source));
        } else {
            WebServiceMessage webServiceMessage = messageFactory.createWebServiceMessage();
            XmlUtil.transform(source, webServiceMessage.getPayloadResult());
            result = webServiceMessage;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated message: " + XmlUtil.serialize(XmlUtil.getEnvelopeSource(result))));
        }
        return result;
    }

    public WebServiceMessage createResponse(URI uri, WebServiceMessage request, WebServiceMessageFactory messageFactory) throws IOException {
        return this.createMessage(uri, request, messageFactory);
    }

    public WebServiceMessage createRequest(WebServiceMessageFactory messageFactory) throws IOException {
        return this.createMessage(null, null, messageFactory);
    }

    protected Source preprocessSource(URI uri, WebServiceMessage input, WebServiceMessageFactory messageFactory) {
        return this.getSource();
    }

    public final Source getSource() {
        return this.source;
    }
}

