/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.javacrumbs.smock.common.TemplateProcessor;
import net.javacrumbs.smock.common.XmlUtil;
import net.javacrumbs.smock.common.XsltTemplateProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.test.support.MockStrategiesHelper;
import org.springframework.xml.transform.ResourceSource;
import org.w3c.dom.Document;

public abstract class SmockCommon {
    private static TemplateProcessor templateProcessor = new XsltTemplateProcessor();
    private static ResourceLoader resourceLoader = new DefaultResourceLoader();

    protected static Document loadDocument(Source message) {
        return XmlUtil.loadDocument(message);
    }

    protected static Source createSource(Resource resource) {
        try {
            return new DOMSource(SmockCommon.loadDocument((Source)new ResourceSource(resource)));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(resource + " could not be opened", ex);
        }
    }

    public static Source fromResource(String location) {
        return SmockCommon.createSource(SmockCommon.resource(location));
    }

    public static Resource resource(String location) {
        return resourceLoader.getResource(location);
    }

    public static TemplateProcessor getTemplateProcessor() {
        return templateProcessor;
    }

    public static void setTemplateProcessor(TemplateProcessor templateProcessor) {
        Assert.notNull((Object)templateProcessor, (String)"'templateProcessor' can not be null");
        SmockCommon.templateProcessor = templateProcessor;
    }

    public static ResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' can not be null");
        SmockCommon.resourceLoader = resourceLoader;
    }

    public static WebServiceMessageFactory createMessageFactory(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return SmockCommon.createMessageFactory();
        }
        return (WebServiceMessageFactory)new MockStrategiesHelper(applicationContext).getStrategy(WebServiceMessageFactory.class, SaajSoapMessageFactory.class);
    }

    public static WebServiceMessageFactory createMessageFactory() {
        return SmockCommon.createMessageFactory(SoapVersion.SOAP_11);
    }

    public static WebServiceMessageFactory createMessageFactory(SoapVersion soapVersion) {
        SaajSoapMessageFactory saajSoapMessageFactory = new SaajSoapMessageFactory();
        saajSoapMessageFactory.setSoapVersion(soapVersion);
        saajSoapMessageFactory.afterPropertiesSet();
        return saajSoapMessageFactory;
    }
}

