/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import net.javacrumbs.smock.common.MessageMatcher;
import net.javacrumbs.smock.common.TemplateProcessor;
import net.javacrumbs.smock.common.client.ParametrizableRequestMatcher;
import net.javacrumbs.smock.common.server.ParametrizableResponseMatcher;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateAwareMessageMatcher
extends MessageMatcher
implements ParametrizableResponseMatcher,
ParametrizableRequestMatcher {
    private final Map<String, Object> parameters;
    private final TemplateProcessor templateProcessor;

    public TemplateAwareMessageMatcher(Source controlMessage, Map<String, Object> parameters, TemplateProcessor templateProcessor) {
        super(controlMessage);
        Assert.notNull((Object)templateProcessor, (String)"TemplateProcessor can not be null");
        this.parameters = new HashMap<String, Object>(parameters);
        this.templateProcessor = templateProcessor;
    }

    @Override
    protected Source preprocessControlMessage(WebServiceMessage input) {
        Source inputSource = input != null ? input.getPayloadSource() : null;
        return this.templateProcessor.processTemplate(this.getControlMessage(), inputSource, this.parameters);
    }

    @Override
    public TemplateAwareMessageMatcher withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public TemplateAwareMessageMatcher withParameters(Map<String, Object> additionalParameters) {
        this.parameters.putAll(additionalParameters);
        return this;
    }

    Map<String, Object> getParameters() {
        return this.parameters;
    }
}

