/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.springws.server;

import net.javacrumbs.smock.common.server.CommonSmockServer;
import net.javacrumbs.smock.springws.server.InterceptingMessageReceiver;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.soap.server.SoapMessageDispatcher;
import org.springframework.ws.test.server.MockWebServiceClient;
import org.springframework.ws.test.support.MockStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public class SmockServer
extends CommonSmockServer {
    public static MockWebServiceClient createClient(WebServiceMessageReceiver messageReceiver, WebServiceMessageFactory messageFactory, ClientInterceptor[] interceptors) {
        return MockWebServiceClient.createClient((WebServiceMessageReceiver)new InterceptingMessageReceiver(messageReceiver, interceptors), (WebServiceMessageFactory)messageFactory);
    }

    public static MockWebServiceClient createClient(ApplicationContext applicationContext, ClientInterceptor[] interceptors) {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        MockStrategiesHelper strategiesHelper = new MockStrategiesHelper(applicationContext);
        WebServiceMessageReceiver messageReceiver = (WebServiceMessageReceiver)strategiesHelper.getStrategy(WebServiceMessageReceiver.class, SoapMessageDispatcher.class);
        WebServiceMessageFactory messageFactory = (WebServiceMessageFactory)strategiesHelper.getStrategy(WebServiceMessageFactory.class, SaajSoapMessageFactory.class);
        return SmockServer.createClient(messageReceiver, messageFactory, interceptors);
    }
}

