/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.javacrumbs.springws.test.AbstractMockWebServiceMessageSender;
import net.javacrumbs.springws.test.RequestProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.ws.transport.WebServiceMessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWebServiceMessageSender
extends AbstractMockWebServiceMessageSender
implements WebServiceMessageSender,
InitializingBean,
ApplicationContextAware {
    private List<RequestProcessor> requestProcessors = new ArrayList<RequestProcessor>();
    private boolean autowireRequestProcessors = true;
    private ApplicationContext applicationContext;

    @Override
    public List<RequestProcessor> getRequestProcessors() {
        return Collections.unmodifiableList(this.requestProcessors);
    }

    public void setRequestProcessors(List<? extends RequestProcessor> requestProcessors) {
        this.requestProcessors = new ArrayList<RequestProcessor>(requestProcessors);
    }

    public void afterPropertiesSet() {
        this.autowireRequestProcessors();
    }

    private void autowireRequestProcessors() {
        ArrayList processors;
        if (this.isAutowireRequestProcessors() && !(processors = new ArrayList(this.applicationContext.getBeansOfType(RequestProcessor.class).values())).isEmpty()) {
            processors.addAll(this.requestProcessors);
            Collections.sort(processors, new OrderComparator());
            this.requestProcessors = processors;
        }
    }

    public boolean isAutowireRequestProcessors() {
        return this.autowireRequestProcessors;
    }

    public void setAutowireRequestProcessors(boolean autowireResponseGenerators) {
        this.autowireRequestProcessors = autowireResponseGenerators;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

