/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.common;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.javacrumbs.springws.test.WsTestException;
import net.javacrumbs.springws.test.common.EnhancedDiff;
import net.javacrumbs.springws.test.common.MessageComparator;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.w3c.dom.Document;

public class DefaultMessageComparator
implements MessageComparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();
    private boolean ignoreWhitespace = true;

    public void compareMessage(WebServiceMessage message, Resource controlResource) throws IOException {
        Document controlDocument = this.loadDocument(controlResource);
        if (this.isSoap(controlDocument)) {
            Document messageDocument = this.loadDocument(message);
            this.compareDocuments(controlDocument, messageDocument);
        } else {
            Document payloadDocument = this.loadDocument(message.getPayloadSource());
            this.compareDocuments(controlDocument, payloadDocument);
        }
    }

    protected void compareDocuments(Document controlDocument, Document messageDocument) {
        Diff diff;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Comparing \"" + this.serializeDocument(controlDocument) + " \"\n with \n\"" + this.serializeDocument(messageDocument) + "\""));
        }
        if (!(diff = this.createDiff(controlDocument, messageDocument)).similar()) {
            this.logger.debug((Object)"Messages different, throwing exception");
            throw new WsTestException("Message is different " + diff.toString(), new DOMSource(messageDocument), new DOMSource(controlDocument));
        }
    }

    protected Diff createDiff(Document controlDocument, Document messageDocument) {
        if (this.ignoreWhitespace != XMLUnit.getIgnoreWhitespace()) {
            XMLUnit.setIgnoreWhitespace((boolean)this.ignoreWhitespace);
        }
        return new EnhancedDiff(controlDocument, messageDocument);
    }

    protected String serializeDocument(Document document) {
        return this.getXmlUtil().serializeDocument(document);
    }

    protected boolean isSoap(Document document) {
        return this.xmlUtil.isSoap(document);
    }

    protected Document loadDocument(WebServiceMessage message) throws IOException {
        return this.getXmlUtil().loadDocument(message);
    }

    protected Document loadDocument(Resource resource) throws IOException {
        return this.getXmlUtil().loadDocument(resource);
    }

    protected Document loadDocument(Source source) {
        return this.getXmlUtil().loadDocument(source);
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }
}

