/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.transport.http.HttpTransportException;

class DefaultStrategiesHelperFactory {
    private static final String DEFAULT_STRATEGIES_PATH = "MessageDispatcherServlet.properties";
    private static final Log logger = LogFactory.getLog(DefaultStrategiesHelperFactory.class);
    private static final String DEFAULT_MESSAGE_FACTORY_BEAN_NAME = "messageFactory";

    DefaultStrategiesHelperFactory() {
    }

    public static DefaultStrategiesHelper getDefaultStrategiesHelper() {
        return new DefaultStrategiesHelper((Resource)new ClassPathResource(DEFAULT_STRATEGIES_PATH, HttpTransportException.class));
    }

    public static WebServiceMessageFactory createMessageFactory(ApplicationContext applicationContext) {
        if (applicationContext != null && applicationContext.containsBean(DEFAULT_MESSAGE_FACTORY_BEAN_NAME)) {
            return (WebServiceMessageFactory)applicationContext.getBean(DEFAULT_MESSAGE_FACTORY_BEAN_NAME, WebServiceMessageFactory.class);
        }
        logger.debug((Object)"No WebServiceMessageFactory found, using default");
        return (WebServiceMessageFactory)DefaultStrategiesHelperFactory.getDefaultStrategiesHelper().getDefaultStrategy(WebServiceMessageFactory.class, applicationContext);
    }
}

