/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.helper.DefaultStrategiesHelperFactory;
import net.javacrumbs.springws.test.helper.InMemoryWebServiceConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.WebServiceMessageReceiver;
import org.springframework.ws.transport.WebServiceMessageSender;

public class InMemoryWebServiceMessageSender
implements WebServiceMessageSender,
ApplicationContextAware,
InitializingBean {
    private WebServiceMessageFactory messageFactory;
    private WebServiceMessageReceiver webServiceMessageReceiver;
    private ApplicationContext applicationContext;
    private static final String DEFAULT_MESSAGE_RECEIVER_BEAN_NAME = "messageReceiver";
    private final Log logger = LogFactory.getLog(this.getClass());

    public InMemoryWebServiceConnection createConnection(URI uri) throws IOException {
        return new InMemoryWebServiceConnection(uri, this.messageFactory, this.webServiceMessageReceiver);
    }

    public boolean supports(URI uri) {
        return true;
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public WebServiceMessageReceiver getWebServiceMessageReceiver() {
        return this.webServiceMessageReceiver;
    }

    protected WebServiceMessageReceiver createWebServiceMessageReceiver() {
        if (this.applicationContext != null && this.applicationContext.containsBean(DEFAULT_MESSAGE_RECEIVER_BEAN_NAME)) {
            return (WebServiceMessageReceiver)this.applicationContext.getBean(DEFAULT_MESSAGE_RECEIVER_BEAN_NAME, WebServiceMessageReceiver.class);
        }
        this.logger.debug((Object)"No WebServiceMessageReceiver found, using default");
        return (WebServiceMessageReceiver)DefaultStrategiesHelperFactory.getDefaultStrategiesHelper().getDefaultStrategy(WebServiceMessageReceiver.class, this.applicationContext);
    }

    public void afterPropertiesSet() {
        this.initializeMessageReceiver();
        this.initializeMessageFactory();
    }

    protected void initializeMessageReceiver() {
        if (this.webServiceMessageReceiver == null) {
            this.webServiceMessageReceiver = this.createWebServiceMessageReceiver();
        }
    }

    protected void initializeMessageFactory() {
        if (this.messageFactory == null) {
            this.messageFactory = DefaultStrategiesHelperFactory.createMessageFactory(this.applicationContext);
        }
    }

    void setWebServiceMessageReceiver(WebServiceMessageReceiver webServiceMessageReceiver) {
        this.webServiceMessageReceiver = webServiceMessageReceiver;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }
}

