/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.javacrumbs.springws.test.template.TemplateProcessor;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.xml.transform.ResourceSource;
import org.w3c.dom.Document;

public class XsltTemplateProcessor
implements TemplateProcessor {
    private static final String XSL_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    private final Log logger = LogFactory.getLog(this.getClass());
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();

    public Resource processTemplate(Resource resource, WebServiceMessage message) throws IOException {
        if (resource != null) {
            if (this.isTemplate(resource)) {
                return this.transform(resource, message);
            }
            return resource;
        }
        return null;
    }

    protected boolean isTemplate(Resource resource) throws IOException {
        Document document = this.loadDocument(resource);
        return XSL_NAMESPACE.equals(document.getFirstChild().getNamespaceURI());
    }

    protected Document loadDocument(Resource resource) throws IOException {
        return this.getXmlUtil().loadDocument(resource);
    }

    protected Resource transform(Resource resource, WebServiceMessage message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Source envelopeSource = message != null ? this.getXmlUtil().getEnvelopeSource(message) : new DOMSource();
        this.getXmlUtil().transform((Source)new ResourceSource(resource), envelopeSource, new StreamResult(baos));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Transformation result:\n" + new String(baos.toByteArray(), "UTF-8")));
        }
        return new ByteArrayResource(baos.toByteArray());
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }
}

