/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.xml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.javacrumbs.springws.test.MockWebServiceMessageSender;
import net.javacrumbs.springws.test.expression.XPathExpressionResolver;
import net.javacrumbs.springws.test.generator.DefaultResponseGenerator;
import net.javacrumbs.springws.test.lookup.PayloadRootBasedResourceLookup;
import net.javacrumbs.springws.test.template.FreeMarkerTemplateProcessor;
import net.javacrumbs.springws.test.template.XsltTemplateProcessor;
import net.javacrumbs.springws.test.util.MockMessageSenderInjector;
import net.javacrumbs.springws.test.validator.SchemaRequestValidator;
import net.javacrumbs.springws.test.validator.XmlCompareRequestValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWsMessageSenderBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String TRUE = Boolean.TRUE.toString();

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        Map<?, ?> namespaces = this.parseNamespaces(element, parserContext, bean);
        Map<?, ?> discriminators = this.parseDiscriminators(element, parserContext, bean);
        Element resourceConfig = DomUtils.getChildElementByTagName((Element)element, (String)"resource-config");
        String pathPrefix = resourceConfig.getAttribute("pathPrefix");
        String prependUri = resourceConfig.getAttribute("prependUri");
        String ignoreWhitespace = resourceConfig.getAttribute("ignoreWhitespace");
        BeanDefinitionBuilder templateProcessor = this.getTemplateProcessor(resourceConfig);
        bean.addPropertyValue("autowireRequestProcessors", (Object)element.getAttribute("autowireRequestProcessors"));
        BeanDefinitionBuilder expressionResolver = BeanDefinitionBuilder.rootBeanDefinition(XPathExpressionResolver.class);
        expressionResolver.addPropertyValue("namespaceMap", namespaces);
        ManagedList requestProcessors = new ManagedList();
        BeanDefinitionBuilder controlResourceLookup = BeanDefinitionBuilder.rootBeanDefinition(PayloadRootBasedResourceLookup.class);
        controlResourceLookup.addPropertyValue("expressionResolver", (Object)expressionResolver.getBeanDefinition());
        controlResourceLookup.addPropertyValue("discriminators", discriminators);
        controlResourceLookup.addPropertyValue("pathPrefix", (Object)pathPrefix);
        controlResourceLookup.addPropertyValue("prependUri", (Object)prependUri);
        controlResourceLookup.addPropertyValue("pathSuffix", (Object)"request.xml");
        controlResourceLookup.addPropertyValue("templateProcessor", (Object)templateProcessor.getBeanDefinition());
        BeanDefinitionBuilder xmlCompareRequestValidator = BeanDefinitionBuilder.rootBeanDefinition(XmlCompareRequestValidator.class);
        xmlCompareRequestValidator.addPropertyValue("controlResourceLookup", (Object)controlResourceLookup.getBeanDefinition());
        xmlCompareRequestValidator.addPropertyValue("ignoreWhitespace", (Object)ignoreWhitespace);
        this.addRequestProcessor(requestProcessors, xmlCompareRequestValidator);
        String[] schemas = this.parseRequestValidationSchemas(element, bean);
        if (schemas != null) {
            BeanDefinitionBuilder schemaRequestValidator = BeanDefinitionBuilder.rootBeanDefinition(SchemaRequestValidator.class);
            schemaRequestValidator.addPropertyValue("schemas", (Object)schemas);
            this.addRequestProcessor(requestProcessors, schemaRequestValidator);
        }
        BeanDefinitionBuilder responseResourceLookup = BeanDefinitionBuilder.rootBeanDefinition(PayloadRootBasedResourceLookup.class);
        responseResourceLookup.addPropertyValue("expressionResolver", (Object)expressionResolver.getBeanDefinition());
        responseResourceLookup.addPropertyValue("discriminators", discriminators);
        responseResourceLookup.addPropertyValue("pathPrefix", (Object)pathPrefix);
        responseResourceLookup.addPropertyValue("prependUri", (Object)prependUri);
        responseResourceLookup.addPropertyValue("pathSuffix", (Object)"response.xml");
        responseResourceLookup.addPropertyValue("templateProcessor", (Object)templateProcessor.getBeanDefinition());
        BeanDefinitionBuilder defaultResponseGenerator = BeanDefinitionBuilder.rootBeanDefinition(DefaultResponseGenerator.class);
        defaultResponseGenerator.addPropertyValue("resourceLookup", (Object)responseResourceLookup.getBeanDefinition());
        this.addRequestProcessor(requestProcessors, defaultResponseGenerator);
        bean.addPropertyValue("requestProcessors", (Object)requestProcessors);
        if (TRUE.equals(element.getAttribute("autoinjectMock"))) {
            AbstractBeanDefinition injector = BeanDefinitionBuilder.rootBeanDefinition(MockMessageSenderInjector.class).getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)injector, parserContext.getReaderContext().generateBeanName((BeanDefinition)injector));
            this.registerBeanDefinition(holder, parserContext.getRegistry());
        }
        bean.addPropertyValue("interceptors", this.parseInterceptors(element, parserContext, bean));
    }

    private BeanDefinitionBuilder getTemplateProcessor(Element resourceConfig) {
        String templateProcessorName = resourceConfig.getAttribute("templateProcessor");
        if ("FreeMarker".equals(templateProcessorName)) {
            return BeanDefinitionBuilder.rootBeanDefinition(FreeMarkerTemplateProcessor.class);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(XsltTemplateProcessor.class);
    }

    protected boolean addRequestProcessor(ManagedList requestProcessors, BeanDefinitionBuilder schemaRequestValidator) {
        return requestProcessors.add((Object)schemaRequestValidator.getBeanDefinition());
    }

    protected String[] parseRequestValidationSchemas(Element element, BeanDefinitionBuilder bean) {
        Element schemas = DomUtils.getChildElementByTagName((Element)element, (String)"schemas");
        if (schemas != null) {
            return this.tokenize(schemas);
        }
        return null;
    }

    protected Map<?, ?> parseDiscriminators(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        Element discriminators = DomUtils.getChildElementByTagName((Element)DomUtils.getChildElementByTagName((Element)element, (String)"resource-config"), (String)"discriminators");
        if (discriminators != null) {
            return parserContext.getDelegate().parseMapElement(discriminators, (BeanDefinition)bean.getRawBeanDefinition());
        }
        this.logger.warn((Object)"No discriminators found");
        return Collections.emptyMap();
    }

    protected List<?> parseInterceptors(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        Element interceptors = DomUtils.getChildElementByTagName((Element)element, (String)"interceptors");
        if (interceptors != null) {
            return parserContext.getDelegate().parseListElement(interceptors, (BeanDefinition)bean.getRawBeanDefinition());
        }
        return Collections.emptyList();
    }

    protected Map<?, ?> parseNamespaces(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        Element namespaces = DomUtils.getChildElementByTagName((Element)element, (String)"namespaces");
        if (namespaces != null) {
            return parserContext.getDelegate().parseMapElement(namespaces, (BeanDefinition)bean.getRawBeanDefinition());
        }
        this.logger.warn((Object)"No namespaces found");
        return Collections.emptyMap();
    }

    protected String[] tokenize(Element array) {
        return array.getTextContent().trim().split("\\s+");
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        return MockWebServiceMessageSender.class;
    }
}

