/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.log4j.Logger;

public class MockServletContext
implements ServletContext {
    private static Logger logger = Logger.getLogger((Class)MockServletContext.class);
    private String baseDir;
    private Map initParameters = new HashMap();
    private Map attributes = new HashMap();

    public MockServletContext() {
    }

    public MockServletContext(String baseDir, String tempDir) {
        this.baseDir = baseDir.replace('/', File.separatorChar);
        this.baseDir = this.baseDir.replaceAll("%20", " ");
        tempDir = tempDir.replace('/', File.separatorChar);
        tempDir = tempDir.replaceAll("%20", " ");
        this.setAttribute("javax.servlet.context.tempdir", new File(tempDir));
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public void putInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void setInitParameters(Map initParameters) {
        this.initParameters = initParameters;
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new IteratorEnumeration(this.initParameters.keySet().iterator());
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 5;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new RuntimeException("operation not supported");
    }

    public String getRealPath(String path) {
        return this.baseDir + path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new RuntimeException("operation not supported");
    }

    public URL getResource(String path) throws MalformedURLException {
        URL url = null;
        File file = new File(this.baseDir + path);
        if (file.exists()) {
            url = file.toURI().toURL();
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        path = path.replace('/', File.separatorChar);
        FileInputStream is = null;
        try {
            is = new FileInputStream(new File(this.baseDir, path));
        }
        catch (FileNotFoundException e) {
            logger.info((Object)("File for path : '" + path + "' not found"));
        }
        return is;
    }

    public Set getResourcePaths(String path) {
        HashSet<String> result = new HashSet<String>();
        File resource = new File(this.baseDir, path = path.replace('/', File.separatorChar));
        String[] resArray = resource.list();
        if (null == resArray) {
            return result;
        }
        for (int i = 0; i < resArray.length; ++i) {
            resArray[i] = path + resArray[i];
            if (!this.isDirectory(resArray[i])) continue;
            int n = i;
            resArray[n] = resArray[n] + '/';
        }
        result.addAll(Arrays.asList(resArray));
        return result;
    }

    public boolean isDirectory(String path) {
        path = path.replace('/', File.separatorChar);
        return new File(this.baseDir, path).isDirectory();
    }

    public String getServerInfo() {
        throw new RuntimeException("operation not supported");
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new RuntimeException("operation not supported");
    }

    public String getServletContextName() {
        throw new RuntimeException("operation not supported");
    }

    public Enumeration getServletNames() {
        throw new RuntimeException("operation not supported");
    }

    public Enumeration getServlets() {
        throw new RuntimeException("operation not supported");
    }

    public void log(String msg) {
        logger.info((Object)msg);
    }

    public void log(Exception exception, String msg) {
        logger.info((Object)msg, (Throwable)exception);
    }

    public void log(String message, Throwable throwable) {
        logger.info((Object)message, throwable);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }
}

