/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.util.StringUtils;

public class MockServletRequest
implements HttpServletRequest {
    private String requestPath;
    private String requestURI;
    private String requestURL;
    private String servletPath;
    private String pathInfo;
    private HttpSession session;
    private Map parameters = new HashMap();

    public void setRequestPath(String mapping, String path) {
        this.requestPath = path;
        int paramStartIdx = this.requestPath.indexOf("?");
        if (StringUtils.isEmpty((String)mapping)) {
            this.servletPath = paramStartIdx != -1 ? this.requestPath.substring(0, paramStartIdx) : this.requestPath;
        } else {
            String pathInfo;
            this.servletPath = PathNormalizer.asPath((String)mapping);
            this.pathInfo = pathInfo = this.removeServletMappingFromPath(path, mapping);
        }
        this.requestURI = paramStartIdx == -1 ? this.requestPath : this.requestPath.substring(0, paramStartIdx);
        this.initParameters();
    }

    private String removeServletMappingFromPath(String path, String mapping) {
        if (mapping != null && mapping.length() > 0) {
            int idx = path.indexOf(mapping);
            if (idx > -1) {
                path = path.substring(idx + mapping.length());
            }
            path = PathNormalizer.asPath((String)path);
        }
        return path;
    }

    private void initParameters() {
        int idx = this.requestPath.indexOf("?");
        if (idx != -1) {
            String strParams = null;
            try {
                strParams = URLDecoder.decode(this.requestPath.substring(idx + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException neverHappens) {
                throw new RuntimeException("Something went unexpectedly wrong while decoding a URL for a generator. ", neverHappens);
            }
            String[] params = strParams.split("&");
            for (int i = 0; i < params.length; ++i) {
                String[] param = params[i].split("=");
                this.parameters.put(param[0], param[1]);
            }
        } else {
            this.parameters.clear();
        }
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public String getAuthType() {
        throw new RuntimeException("Unsupported operation");
    }

    public String getContextPath() {
        return "";
    }

    public String getMethod() {
        return "GET";
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return null;
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public Enumeration getHeaders(String name) {
        return null;
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer result = null;
        if (this.requestURL != null) {
            result = new StringBuffer(this.requestURL);
        }
        return result;
    }

    public String getRequestedSessionId() {
        return this.session.getId();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object o) {
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public void setRequestUrl(String url) {
        this.requestURL = url;
    }
}

