/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.cache;

import net.jawr.web.cache.BasicCacheManager;
import net.jawr.web.cache.JawrCacheManager;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;

public class CacheManagerFactory {
    public static JawrCacheManager getCacheManager(JawrConfig config, String resourceType) {
        String cacheMgrAttributeName = "JAWR." + resourceType.toUpperCase() + ".CACHE.MANAGER";
        JawrCacheManager cacheManager = (JawrCacheManager)config.getContext().getAttribute(cacheMgrAttributeName);
        if (cacheManager == null) {
            String cacheManagerClass = config.getProperty("jawr.cache.manager", BasicCacheManager.class.getName());
            cacheManager = (JawrCacheManager)ClassLoaderResourceUtils.buildObjectInstance(cacheManagerClass, new Object[]{config});
            config.getContext().setAttribute(cacheMgrAttributeName, (Object)cacheManager);
        }
        return cacheManager;
    }

    public static synchronized JawrCacheManager resetCacheManager(JawrConfig config, String resourceType) {
        String cacheMgrAttributeName = "JAWR." + resourceType.toUpperCase() + ".CACHE.MANAGER";
        JawrCacheManager cacheManager = (JawrCacheManager)config.getContext().getAttribute(cacheMgrAttributeName);
        if (cacheManager != null) {
            cacheManager.clear();
            config.getContext().removeAttribute(cacheMgrAttributeName);
        }
        return CacheManagerFactory.getCacheManager(config, resourceType);
    }
}

