/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.minification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;

public class CSSMinifier {
    private static final String COMMENT_REGEX = "(/\\*[^*]*\\*+([^/][^*]*\\*+)*/)";
    private static final String QUOTED_CONTENT_REGEX = "([\"']).*?\\1";
    private static final String STRING_PLACEHOLDER = "______'JAWR_STRING'______";
    private static final String RULES_REGEX = "([^\\{\\}]*)(\\{[^\\{\\}]*})";
    private static final String NEW_LINE_TABS_REGEX = "\\r|\\n|\\t|\\f";
    private static final String SPACES_REGEX = "(?ims)(\\s*\\{\\s*)|(\\s*\\}\\s*)|((?<!\\sand)\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)";
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("(/\\*[^*]*\\*+([^/][^*]*\\*+)*/)", 32);
    private static final Pattern SPACES_PATTERN = Pattern.compile("(?ims)(\\s*\\{\\s*)|(\\s*\\}\\s*)|((?<!\\sand)\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)", 32);
    private static final Pattern QUOTED_CONTENT_PATTERN = Pattern.compile("([\"']).*?\\1", 32);
    private static final Pattern RULES_PATTERN = Pattern.compile("([^\\{\\}]*)(\\{[^\\{\\}]*})", 32);
    private static final Pattern NEW_LINES_TAB_PATTERN = Pattern.compile("\\r|\\n|\\t|\\f", 32);
    private static final Pattern STRING_PLACE_HOLDE_PATTERN = Pattern.compile("______'JAWR_STRING'______", 32);
    private static final String SPACE = " ";
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String PAREN_OPEN = "(";
    private static final String PAREN_CLOSE = ")";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";

    public StringBuffer minifyCSS(StringBuffer data) {
        String compressed = COMMENTS_PATTERN.matcher(data.toString()).replaceAll("");
        final ArrayList strings = new ArrayList();
        Matcher stringMatcher = QUOTED_CONTENT_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String match = matcher.group();
                strings.add(match);
                return CSSMinifier.STRING_PLACEHOLDER;
            }
        }.processWithMatcher(stringMatcher);
        Matcher rulesmatcher = RULES_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String match = matcher.group(1);
                String spaced = NEW_LINES_TAB_PATTERN.matcher(match.toString()).replaceAll(CSSMinifier.SPACE).trim();
                return spaced + matcher.group(2);
            }
        }.processWithMatcher(rulesmatcher);
        compressed = NEW_LINES_TAB_PATTERN.matcher(compressed).replaceAll(SPACE);
        Matcher matcher = SPACES_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String replacement = CSSMinifier.SPACE;
                String match = matcher.group();
                if (match.indexOf(CSSMinifier.BRACKET_OPEN) != -1) {
                    replacement = CSSMinifier.BRACKET_OPEN;
                } else if (match.indexOf(CSSMinifier.BRACKET_CLOSE) != -1) {
                    replacement = CSSMinifier.BRACKET_CLOSE;
                } else if (match.indexOf(CSSMinifier.PAREN_OPEN) != -1) {
                    replacement = CSSMinifier.PAREN_OPEN;
                } else if (match.indexOf(CSSMinifier.COLON) != -1) {
                    replacement = CSSMinifier.COLON;
                } else if (match.indexOf(CSSMinifier.SEMICOLON) != -1) {
                    replacement = CSSMinifier.SEMICOLON;
                } else if (match.indexOf(CSSMinifier.PAREN_CLOSE) != -1) {
                    replacement = CSSMinifier.PAREN_CLOSE;
                }
                return replacement;
            }
        }.processWithMatcher(matcher);
        Matcher restoreMatcher = STRING_PLACE_HOLDE_PATTERN.matcher(compressed);
        final Iterator it = strings.iterator();
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String replacement = (String)it.next();
                return replacement;
            }
        }.processWithMatcher(restoreMatcher);
        return new StringBuffer(compressed);
    }

    public abstract class MatcherProcessorCallback {
        String processWithMatcher(Matcher matcher) {
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(this.matchCallback(matcher)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        abstract String matchCallback(Matcher var1);
    }
}

