/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class ImageResourcesHandler {
    private Map<String, String> imageMap = new ConcurrentHashMap<String, String>();
    private JawrConfig jawrConfig;
    private ResourceReaderHandler rsHandler;
    private ResourceBundleHandler rsBundleHandler;

    public ImageResourcesHandler(JawrConfig config, ResourceReaderHandler rsHandler, ResourceBundleHandler rsBundleHandler) {
        this.jawrConfig = config;
        this.rsHandler = rsHandler;
        this.rsBundleHandler = rsBundleHandler;
    }

    public JawrConfig getConfig() {
        return this.jawrConfig;
    }

    public void setJawrConfig(JawrConfig jawrConfig) {
        this.jawrConfig = jawrConfig;
    }

    public ResourceReaderHandler getRsReaderHandler() {
        return this.rsHandler;
    }

    public ResourceBundleHandler getRsBundleHandler() {
        return this.rsBundleHandler;
    }

    public void setRsReaderHandler(ResourceReaderHandler rsHandler) {
        this.rsHandler = rsHandler;
    }

    public Map<String, String> getImageMap() {
        return this.imageMap;
    }

    public void addMapping(String imgUrl, String cacheUrl) {
        this.imageMap.put(imgUrl, cacheUrl);
    }

    public String getCacheUrl(String imgUrl) {
        return this.imageMap.get(imgUrl);
    }

    public void clear() {
        this.imageMap.clear();
    }

    public boolean containsValidBundleHashcode(String requestedPath) {
        return this.imageMap.containsValue(requestedPath);
    }
}

