/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.util.List;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class CompositeResourceBundle
extends JoinableResourceBundleImpl {
    private List<JoinableResourceBundle> childBundles;

    public CompositeResourceBundle(String id, String name, List<JoinableResourceBundle> childBundles, InclusionPattern inclusionPattern, ResourceReaderHandler resourceHandler, String bundlePrefix, String fileExtension, JawrConfig config) {
        super(id, name, bundlePrefix, fileExtension, inclusionPattern, resourceHandler, config.getGeneratorRegistry());
        this.childBundles = childBundles;
        for (JoinableResourceBundle child : this.childBundles) {
            if (!child.getInclusionPattern().isIncludeOnlyOnDebug()) {
                this.itemPathList.addAll(child.getItemPathList());
            }
            if (!child.getInclusionPattern().isExcludeOnDebug()) {
                this.itemDebugPathList.addAll(child.getItemDebugPathList());
            }
            this.licensesPathList.addAll(child.getLicensesPathList());
            if (null == child.getBundlePostProcessor()) {
                child.setBundlePostProcessor(this.getBundlePostProcessor());
            }
            if (null != child.getUnitaryPostProcessor()) continue;
            child.setUnitaryPostProcessor(this.getUnitaryPostProcessor());
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public List<JoinableResourceBundle> getChildBundles() {
        return this.childBundles;
    }

    @Override
    public String toString() {
        return "CompositeResourceBundleImpl [id=" + this.getId() + ", name=" + this.getName() + "]";
    }
}

