/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.sorting.SortFileParser;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinableResourceBundleImpl
implements JoinableResourceBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinableResourceBundleImpl.class);
    private String name;
    private String id;
    private InclusionPattern inclusionPattern;
    private List<String> pathMappings;
    protected List<BundlePath> itemPathList;
    protected List<BundlePath> itemDebugPathList;
    private ResourceReaderHandler resourceReaderHandler;
    private GeneratorRegistry generatorRegistry;
    protected Set<String> licensesPathList;
    private String bundlePrefix;
    private String fileExtension;
    private String urlPrefix;
    private String explorerConditionalExpression;
    private String alternateProductionURL;
    private Map<String, String> prefixMap;
    protected Map<String, VariantSet> variants;
    protected List<String> variantKeys;
    protected List<JoinableResourceBundle> dependencies;
    private ResourceBundlePostProcessor unitaryPostProcessor;
    private ResourceBundlePostProcessor bundlePostProcessor;

    public JoinableResourceBundleImpl(String id, String name, String bundlePrefix, String fileExtension, InclusionPattern inclusionPattern, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        this.inclusionPattern = inclusionPattern;
        this.generatorRegistry = generatorRegistry;
        this.id = generatorRegistry.isPathGenerated(id) ? id : PathNormalizer.asPath(id);
        this.name = name;
        this.resourceReaderHandler = resourceReaderHandler;
        this.itemPathList = new CopyOnWriteArrayList<BundlePath>();
        this.itemDebugPathList = new CopyOnWriteArrayList<BundlePath>();
        this.licensesPathList = new HashSet<String>();
        if (bundlePrefix != null) {
            this.bundlePrefix = PathNormalizer.asDirPath(bundlePrefix);
        }
        this.fileExtension = fileExtension != null && fileExtension.length() > 0 && fileExtension.charAt(0) != '.' ? "." + fileExtension : fileExtension;
        this.prefixMap = new ConcurrentHashMap<String, String>();
    }

    public JoinableResourceBundleImpl(String id, String name, String bundlePrefix, String fileExtension, InclusionPattern inclusionPattern, List<String> pathMappings, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        this(id, name, bundlePrefix, fileExtension, inclusionPattern, resourceReaderHandler, generatorRegistry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding mapped files for bundle " + id);
        }
        this.pathMappings = pathMappings;
        this.initPathList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added " + this.itemPathList.size() + " files and " + this.licensesPathList.size() + " licenses for the bundle " + id);
        }
    }

    private void initPathList() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating bundle path List for " + this.id);
        }
        for (String pathMapping : this.pathMappings) {
            boolean isGeneratedPath = this.generatorRegistry.isPathGenerated(pathMapping);
            if (pathMapping.endsWith("/")) {
                this.addItemsFromDir(pathMapping, false);
                continue;
            }
            if (pathMapping.endsWith("/**")) {
                this.addItemsFromDir(pathMapping.substring(0, pathMapping.lastIndexOf("**")), true);
                continue;
            }
            if (pathMapping.endsWith(this.fileExtension)) {
                this.addPathMapping(this.asPath(pathMapping, isGeneratedPath));
                continue;
            }
            if (this.generatorRegistry.isPathGenerated(pathMapping)) {
                this.addPathMapping(pathMapping);
                continue;
            }
            if (pathMapping.endsWith(".license")) {
                this.licensesPathList.add(this.asPath(pathMapping, isGeneratedPath));
                continue;
            }
            throw new BundlingProcessException("Wrong mapping [" + pathMapping + "] for bundle [" + this.name + "]. Please check configuration. ");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished creating bundle path List for " + this.id);
        }
    }

    private void addPathMapping(String pathMapping) {
        if (!this.getInclusionPattern().isIncludeOnlyOnDebug()) {
            this.itemPathList.add(new BundlePath(this.bundlePrefix, pathMapping));
        }
        if (!this.getInclusionPattern().isExcludeOnDebug()) {
            this.itemDebugPathList.add(new BundlePath(this.bundlePrefix, pathMapping));
        }
    }

    protected void addItemsFromDir(String dirName, boolean addSubDirs) {
        Set<String> resources = this.resourceReaderHandler.getResourceNames(dirName);
        boolean isGeneratedPath = this.generatorRegistry.isPathGenerated(dirName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding " + resources.size() + " resources from path [" + dirName + "] to bundle " + this.getId());
        }
        if (resources.contains(".sorting") || resources.contains("/.sorting")) {
            Reader reader;
            String sortFilePath = this.joinPaths(dirName, ".sorting", isGeneratedPath);
            try {
                reader = this.resourceReaderHandler.getResource(sortFilePath);
            }
            catch (ResourceNotFoundException e) {
                throw new BundlingProcessException("Unexpected ResourceNotFoundException when reading a sorting file[" + sortFilePath + "]", e);
            }
            SortFileParser parser = new SortFileParser(reader, resources, dirName);
            List<String> sortedResources = parser.getSortedResources();
            for (String resourceName : sortedResources) {
                if (resourceName.endsWith(this.fileExtension) || this.generatorRegistry.isPathGenerated(resourceName)) {
                    this.addPathMapping(this.asPath(resourceName, isGeneratedPath));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Added to item path list from the sorting file:" + resourceName);
                    continue;
                }
                if (!addSubDirs || !this.resourceReaderHandler.isDirectory(resourceName)) continue;
                this.addItemsFromDir(resourceName, true);
            }
        }
        if (resources.contains(".license") || resources.contains("/.license")) {
            this.licensesPathList.add(this.joinPaths(dirName, ".license", isGeneratedPath));
        }
        ArrayList<String> folders = new ArrayList<String>();
        for (String resourceName : resources) {
            String resourcePath = this.joinPaths(dirName, resourceName, isGeneratedPath);
            boolean resourceIsDir = this.resourceReaderHandler.isDirectory(resourcePath);
            if (addSubDirs && resourceIsDir) {
                folders.add(resourceName);
                continue;
            }
            if (!resourcePath.endsWith(this.fileExtension) && (!this.generatorRegistry.isPathGenerated(resourcePath) || resourceIsDir)) continue;
            this.addPathMapping(this.asPath(resourcePath, isGeneratedPath));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Added to item path list:" + this.asPath(resourcePath, isGeneratedPath));
        }
        if (addSubDirs) {
            for (String folderName : folders) {
                this.addItemsFromDir(this.joinPaths(dirName, folderName, isGeneratedPath), true);
            }
        }
    }

    private String asPath(String path, boolean generatedResource) {
        String result = path;
        if (!generatedResource) {
            result = PathNormalizer.asPath(path);
        }
        return result;
    }

    private String joinPaths(String dirName, String folderName, boolean generatedResource) {
        return PathNormalizer.joinPaths(dirName, folderName, generatedResource);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBundlePrefix() {
        return this.bundlePrefix;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public ResourceBundlePostProcessor getUnitaryPostProcessor() {
        return this.unitaryPostProcessor;
    }

    @Override
    public void setUnitaryPostProcessor(ResourceBundlePostProcessor unitaryPostProcessor) {
        this.unitaryPostProcessor = unitaryPostProcessor;
    }

    @Override
    public ResourceBundlePostProcessor getBundlePostProcessor() {
        return this.bundlePostProcessor;
    }

    @Override
    public void setBundlePostProcessor(ResourceBundlePostProcessor bundlePostProcessor) {
        this.bundlePostProcessor = bundlePostProcessor;
    }

    @Override
    public String getExplorerConditionalExpression() {
        return this.explorerConditionalExpression;
    }

    public void setExplorerConditionalExpression(String explorerConditionalExpression) {
        this.explorerConditionalExpression = explorerConditionalExpression;
    }

    @Override
    public void setVariants(Map<String, VariantSet> variantSets) {
        if (variantSets != null) {
            this.variants = new TreeMap<String, VariantSet>(variantSets);
            this.variantKeys = VariantUtils.getAllVariantKeys(this.variants);
        }
    }

    @Override
    public Map<String, VariantSet> getVariants() {
        return this.variants;
    }

    @Override
    public List<String> getVariantKeys() {
        return this.variantKeys;
    }

    @Override
    public String getAlternateProductionURL() {
        return this.alternateProductionURL;
    }

    public void setAlternateProductionURL(String alternateProductionURL) {
        this.alternateProductionURL = alternateProductionURL;
    }

    @Override
    public boolean belongsToBundle(String itemPath) {
        boolean belongsToBundle = false;
        for (BundlePath path : this.itemPathList) {
            if (!path.getPath().equals(itemPath)) continue;
            belongsToBundle = true;
            break;
        }
        if (!belongsToBundle) {
            for (BundlePath path : this.itemDebugPathList) {
                if (!path.getPath().equals(itemPath)) continue;
                belongsToBundle = true;
                break;
            }
        }
        return belongsToBundle;
    }

    @Override
    public InclusionPattern getInclusionPattern() {
        return this.inclusionPattern;
    }

    @Override
    public void setMappings(List<String> pathMappings) {
        this.pathMappings = pathMappings;
        this.initPathList();
    }

    @Override
    public List<BundlePath> getItemPathList() {
        return this.itemPathList;
    }

    @Override
    public List<BundlePath> getItemDebugPathList() {
        return this.itemDebugPathList;
    }

    @Override
    public List<BundlePath> getItemDebugPathList(Map<String, String> variants) {
        return this.getItemPathList(this.itemDebugPathList, variants);
    }

    @Override
    public List<BundlePath> getItemPathList(Map<String, String> variants) {
        return this.getItemPathList(this.itemPathList, variants);
    }

    private List<BundlePath> getItemPathList(List<BundlePath> itemList, Map<String, String> variants) {
        if (variants == null || variants.isEmpty()) {
            return itemList;
        }
        ArrayList<BundlePath> rets = new ArrayList<BundlePath>();
        for (BundlePath bundlePath : itemList) {
            String path = bundlePath.getPath();
            if (this.generatorRegistry.isPathGenerated(path)) {
                Set<String> variantTypes = this.generatorRegistry.getGeneratedResourceVariantTypes(path);
                String variantKey = VariantUtils.getVariantKey(variants, variantTypes);
                if (StringUtils.isNotEmpty(variantKey)) {
                    rets.add(new BundlePath(bundlePath.getBundlePrefix(), VariantUtils.getVariantBundleName(path, variantKey)));
                    continue;
                }
                rets.add(bundlePath);
                continue;
            }
            rets.add(bundlePath);
        }
        return rets;
    }

    @Override
    public void setDependencies(List<JoinableResourceBundle> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public List<JoinableResourceBundle> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<String> getLicensesPathList() {
        return this.licensesPathList;
    }

    public void setLicensesPathList(Set<String> licencePathList) {
        this.licensesPathList = licencePathList;
    }

    @Override
    public String getURLPrefix(Map<String, String> variants) {
        String key;
        if (null == this.urlPrefix) {
            throw new IllegalStateException("The bundleDataHashCode must be set before accessing the url prefix.");
        }
        if (variants != null && !variants.isEmpty() && StringUtils.isNotEmpty(key = this.getAvailableVariant(variants))) {
            return this.prefixMap.get(key) + "." + key + "/";
        }
        return this.urlPrefix + "/";
    }

    @Override
    public String getBundleDataHashCode(String variantKey) {
        if (StringUtils.isEmpty(variantKey)) {
            return this.urlPrefix;
        }
        return this.prefixMap.get(variantKey);
    }

    @Override
    public void setBundleDataHashCode(String variantKey, String bundleDataHashCode) {
        String prefix = bundleDataHashCode;
        if (StringUtils.isEmpty(variantKey)) {
            this.urlPrefix = prefix;
        } else {
            this.prefixMap.put(variantKey, prefix);
        }
    }

    private String getAvailableVariant(Map<String, String> curVariants) {
        String variantKey = null;
        if (this.variants != null) {
            Map<String, String> availableVariants = this.generatorRegistry.getAvailableVariantMap(this.variants, curVariants);
            variantKey = VariantUtils.getVariantKey(availableVariants);
        }
        return variantKey;
    }

    public String toString() {
        return "JoinableResourceBundleImpl [id=" + this.id + ", name=" + this.name + "]";
    }
}

