/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.css;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.util.StringUtils;

public class CssImageUrlRewriter {
    private static final String URL_SEPARATOR = "/";
    public static String URL_REGEXP = "url\\(\\s*(?!(\"|')?(data|mhtml|cid):)(((\\\\\\))|[^)])*)\\s*\\)";
    public static final Pattern URL_PATTERN = Pattern.compile(URL_REGEXP, 2);
    protected ImageResourcesHandler imgRsHandler;
    protected String contextPath;

    public CssImageUrlRewriter() {
    }

    public CssImageUrlRewriter(JawrConfig config) {
        this.setContextPath(config.getProperty("jawr.css.url.rewriter.context.path"));
        this.imgRsHandler = (ImageResourcesHandler)config.getContext().getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE");
    }

    public void setContextPath(String contextPath) {
        if (StringUtils.isNotEmpty(contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            if (contextPath.charAt(contextPath.length() - 1) != '/') {
                contextPath = contextPath + '/';
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
    }

    public StringBuffer rewriteUrl(String originalCssPath, String newCssPath, String originalCssContent) throws IOException {
        Matcher matcher = URL_PATTERN.matcher(originalCssContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String url = this.getUrlPath(matcher.group(), originalCssPath, newCssPath);
            matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(url));
        }
        matcher.appendTail(sb);
        return sb;
    }

    protected String getUrlPath(String match, String originalPath, String newCssPath) throws IOException {
        int firstSlash;
        String url = match.substring(match.indexOf(40) + 1, match.lastIndexOf(41)).trim();
        String quoteStr = "";
        if (url.startsWith("'") || url.startsWith("\"")) {
            quoteStr = url.charAt(0) + "";
            url = url.substring(1, url.length() - 1);
        }
        if (StringUtils.isNotEmpty(this.contextPath) && url.startsWith(this.contextPath)) {
            String rootRelativePath = PathNormalizer.getRootRelativePath(originalPath);
            url = rootRelativePath + url.substring(this.contextPath.length());
        }
        if (0 == (firstSlash = url.indexOf(47)) || firstSlash != -1 && url.charAt(++firstSlash) == '/') {
            StringBuffer sb = new StringBuffer("url(");
            sb.append(quoteStr).append(url).append(quoteStr).append(")");
            return sb.toString();
        }
        if (url.startsWith(URL_SEPARATOR)) {
            url = url.substring(1, url.length());
        } else if (url.startsWith("./")) {
            url = url.substring(2, url.length());
        }
        String imgUrl = this.getRewrittenImagePath(originalPath, newCssPath, url);
        String finalUrl = "url(" + quoteStr + imgUrl + quoteStr + ")";
        Matcher urlMatcher = URL_PATTERN.matcher(finalUrl);
        if (urlMatcher.find()) {
            finalUrl = PathNormalizer.normalizePath(finalUrl);
        }
        return finalUrl;
    }

    protected String getRewrittenImagePath(String originalCssPath, String newCssPath, String url) throws IOException {
        String imgUrl = null;
        boolean generatedImg = false;
        if (this.imgRsHandler != null) {
            GeneratorRegistry imgRsGeneratorRegistry = this.imgRsHandler.getConfig().getGeneratorRegistry();
            generatedImg = imgRsGeneratorRegistry.isGeneratedImage(url);
        }
        String fullImgPath = PathNormalizer.concatWebPath(originalCssPath, url);
        imgUrl = !generatedImg ? PathNormalizer.getRelativeWebPath(PathNormalizer.getParentPath(newCssPath), fullImgPath) : url;
        return imgUrl;
    }
}

