/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceMapper.class);
    protected String baseDir;
    protected ResourceReaderHandler rsHandler;
    protected List<JoinableResourceBundle> currentBundles;
    protected String resourceExtension;
    private Map<String, String> bundleMapping;

    public AbstractResourceMapper(String baseDir, ResourceReaderHandler rsHandler, List<JoinableResourceBundle> currentBundles, String resourceExtension) {
        this.baseDir = baseDir;
        this.rsHandler = rsHandler;
        this.currentBundles = new ArrayList<JoinableResourceBundle>();
        if (null != currentBundles) {
            this.currentBundles.addAll(currentBundles);
        }
        this.resourceExtension = resourceExtension;
        this.bundleMapping = new HashMap<String, String>();
    }

    protected abstract void addBundlesToMapping() throws DuplicateBundlePathException;

    public final Map<String, String> getBundleMapping() throws DuplicateBundlePathException {
        this.addBundlesToMapping();
        return this.bundleMapping;
    }

    protected final void addBundleToMap(String bundleId, String mapping) throws DuplicateBundlePathException {
        for (JoinableResourceBundle bundle : this.currentBundles) {
            if (!bundleId.equals(bundle.getId()) && !this.bundleMapping.containsKey(bundleId)) continue;
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "Duplicate bundle id resulted from mapping:" + bundleId);
            throw new DuplicateBundlePathException(bundleId);
        }
        this.bundleMapping.put(bundleId, mapping);
    }
}

