/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.postprocessor;

import net.jawr.web.resource.bundle.factory.postprocessor.AbstractPostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.postprocessor.PostProcessorChainFactory;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CSSCombineMediaPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CSSImportPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CSSMinPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CSSURLPathRewriterPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CssCharsetFilterPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.css.base64.Base64ImageEncoderPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.yui.YUICSSCompressor;

public class CSSPostProcessorChainFactory
extends AbstractPostProcessorChainFactory
implements PostProcessorChainFactory {
    @Override
    public ResourceBundlePostProcessor buildDefaultProcessorChain() {
        CSSMinPostProcessor processor = new CSSMinPostProcessor();
        processor.addNextProcessor(this.buildLicensesProcessor());
        return processor;
    }

    @Override
    public ResourceBundlePostProcessor buildDefaultUnitProcessorChain() {
        CSSImportPostProcessor processor = new CSSImportPostProcessor();
        processor.addNextProcessor(new CSSURLPathRewriterPostProcessor());
        return processor;
    }

    @Override
    protected AbstractChainedResourceBundlePostProcessor buildProcessorByKey(String processorKey) {
        if ("license".equals(processorKey)) {
            return this.buildLicensesProcessor();
        }
        if ("cssminify".equals(processorKey)) {
            return new CSSMinPostProcessor();
        }
        if ("cssimport".equals(processorKey)) {
            return new CSSImportPostProcessor();
        }
        if ("csscharset".equals(processorKey)) {
            return new CssCharsetFilterPostProcessor();
        }
        if ("cssCombineMedia".equals(processorKey)) {
            return new CSSCombineMediaPostProcessor();
        }
        if ("csspathrewriter".equals(processorKey)) {
            return new CSSURLPathRewriterPostProcessor();
        }
        if ("base64ImageEncoder".equals(processorKey)) {
            return new Base64ImageEncoderPostProcessor();
        }
        if ("YUI".equals(processorKey)) {
            return new YUICSSCompressor();
        }
        throw new IllegalArgumentException("The supplied key [" + processorKey + "] is not bound to any ResourceBundlePostProcessor. Please check the documentation for valid keys. ");
    }
}

