/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import net.jawr.web.resource.bundle.factory.util.ConfigChangeListener;
import net.jawr.web.resource.bundle.factory.util.ConfigPropertiesSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangeListenerThread
extends Thread
implements Serializable {
    private static final long serialVersionUID = -7816209592970823852L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConfigChangeListenerThread.class.getName());
    private long waitMillis;
    private ConfigPropertiesSource propertiesSource;
    private Properties overrideProperties;
    private ConfigChangeListener listener;
    private boolean continuePolling;

    public ConfigChangeListenerThread(ConfigPropertiesSource propertiesSource, Properties overrideProperties, ConfigChangeListener listener, long secondsToWait) {
        this.propertiesSource = propertiesSource;
        this.overrideProperties = overrideProperties;
        this.listener = listener;
        this.waitMillis = secondsToWait * 1000L;
        this.continuePolling = true;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean firstRun = true;
        while (this.continuePolling) {
            try {
                if (!firstRun && this.propertiesSource.configChanged()) {
                    Properties props = this.propertiesSource.getConfigProperties();
                    if (this.overrideProperties != null) {
                        props.putAll((Map<?, ?>)this.overrideProperties);
                    }
                    this.listener.configChanged(props);
                }
                ConfigChangeListenerThread.sleep(this.waitMillis);
                firstRun = false;
            }
            catch (InterruptedException e) {
                LOGGER.error("Failure at config reloading checker thread.");
            }
        }
    }

    public void stopPolling() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping the configuration change polling");
        }
        this.continuePolling = false;
    }
}

