/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.ConfigPropertiesSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsFilePropertiesSource
implements ConfigPropertiesSource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PropsFilePropertiesSource.class.getName());
    private String configLocation;
    protected int propsHashCode;
    protected static final String FILE_PREFIX = "file:";
    private boolean checking;

    @Override
    public final Properties getConfigProperties() {
        Properties props = this.doReadConfig();
        if (0 == this.propsHashCode) {
            this.propsHashCode = props.hashCode();
        }
        return props;
    }

    protected Properties doReadConfig() {
        return this.readConfigFile(this.configLocation);
    }

    protected Properties readConfigFile(String path) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            if (path.startsWith(FILE_PREFIX)) {
                if (LOGGER.isDebugEnabled() && !this.checking) {
                    LOGGER.debug("Using filesystem properties file location at: " + this.configLocation);
                }
                is = new FileInputStream(new File(path.substring(FILE_PREFIX.length())));
            } else {
                if (LOGGER.isDebugEnabled() && !this.checking) {
                    LOGGER.debug("Reading properties from file at classpath: " + this.configLocation);
                }
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            props.load(is);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("jawr configuration could not be found at " + path + ". Make sure parameter is properly set " + "in web.xml. ");
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
        }
        IOUtils.close(is);
        return props;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    @Override
    public final boolean configChanged() {
        boolean configChanged;
        this.checking = true;
        int currentConfigHash = this.doReadConfig().hashCode();
        boolean bl = configChanged = this.propsHashCode != currentConfigHash;
        if (configChanged && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Changes in configuration properties file detected.");
        }
        this.propsHashCode = currentConfigHash;
        return configChanged;
    }
}

