/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class GeneratorContext {
    private static final String PARENFINDER_REGEXP = ".*(\\(.*\\)).*";
    private static final String BRACKFINDER_REGEXP = ".*(\\[.*\\]).*";
    private String path;
    private JawrConfig config;
    private Map<String, String> variantMap;
    private Map<String, VariantSet> variantSets;
    private Locale locale;
    private String parenthesesParam;
    private String bracketsParam;
    private ResourceReaderHandler resourceReaderHandler;
    private boolean processingBundle;

    public GeneratorContext(JawrConfig config, String requestedPath) {
        this.config = config;
        this.path = requestedPath;
        if (this.path.matches(PARENFINDER_REGEXP)) {
            this.parenthesesParam = this.path.substring(this.path.indexOf(40) + 1, this.path.indexOf(41));
            this.path = this.path.substring(0, this.path.indexOf(40)) + this.path.substring(this.path.indexOf(41) + 1);
        }
        if (this.path.matches(BRACKFINDER_REGEXP)) {
            this.bracketsParam = this.path.substring(this.path.indexOf(91) + 1, this.path.indexOf(93));
            this.path = this.path.substring(0, this.path.indexOf(91)) + this.path.substring(this.path.indexOf(93) + 1);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<String, String> getVariantMap() {
        return this.variantMap;
    }

    public void setVariantMap(Map<String, String> variantMap) {
        this.variantMap = variantMap;
    }

    public Map<String, VariantSet> getVariantSets() {
        return this.variantSets;
    }

    public void setVariantSets(Map<String, VariantSet> variantSets) {
        this.variantSets = variantSets;
    }

    public String getPath() {
        return this.path;
    }

    public JawrConfig getConfig() {
        return this.config;
    }

    public ResourceReaderHandler getResourceReaderHandler() {
        return this.resourceReaderHandler;
    }

    public void setResourceReaderHandler(ResourceReaderHandler resourceHandler) {
        this.resourceReaderHandler = resourceHandler;
    }

    public boolean isProcessingBundle() {
        return this.processingBundle;
    }

    public void setProcessingBundle(boolean processingBundle) {
        this.processingBundle = processingBundle;
    }

    public ServletContext getServletContext() {
        return this.config.getContext();
    }

    public Charset getCharset() {
        return this.config.getResourceCharset();
    }

    public String getParenthesesParam() {
        return this.parenthesesParam;
    }

    public String getBracketsParam() {
        return this.bracketsParam;
    }
}

