/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.generator.ResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceGeneratorReaderWrapper;
import net.jawr.web.resource.bundle.generator.StreamResourceGenerator;
import net.jawr.web.resource.bundle.generator.StreamResourceGeneratorReaderWrapper;
import net.jawr.web.resource.bundle.generator.TextResourceGenerator;
import net.jawr.web.resource.handler.reader.ResourceReader;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.StreamResourceReader;
import net.jawr.web.resource.handler.reader.TextResourceReader;

public class ResourceGeneratorReaderProxyFactory {
    public static ResourceReader getResourceReaderProxy(ResourceGenerator generator, ResourceReaderHandler rsReaderHandler, JawrConfig config) {
        int i;
        ResourceReader proxy = null;
        int nbExtraInterface = 0;
        Class[] extraInterfaces = new Class[2];
        boolean isResourceGenerator = generator instanceof ResourceGenerator;
        boolean isStreamResourceGenerator = generator instanceof StreamResourceGenerator;
        if (isResourceGenerator) {
            extraInterfaces[nbExtraInterface++] = TextResourceReader.class;
        }
        if (isStreamResourceGenerator) {
            extraInterfaces[nbExtraInterface++] = StreamResourceReader.class;
        }
        Class<?>[] generatorInterfaces = ResourceGeneratorReaderProxyFactory.getGeneratorInterfaces(generator);
        Class[] implementedInterfaces = new Class[generatorInterfaces.length + nbExtraInterface];
        for (i = 0; i < generatorInterfaces.length; ++i) {
            implementedInterfaces[i] = generatorInterfaces[i];
        }
        for (i = 0; i < nbExtraInterface; ++i) {
            implementedInterfaces[generatorInterfaces.length + i] = extraInterfaces[i];
        }
        ResourceGeneratorReaderWrapperInvocationHandler handler = new ResourceGeneratorReaderWrapperInvocationHandler(generator, rsReaderHandler, config);
        proxy = (ResourceReader)Proxy.newProxyInstance(ResourceGeneratorReaderProxyFactory.class.getClassLoader(), implementedInterfaces, (InvocationHandler)handler);
        return proxy;
    }

    private static Class<?>[] getGeneratorInterfaces(ResourceGenerator generator) {
        HashSet interfaces = new HashSet();
        ResourceGeneratorReaderProxyFactory.addInterfaces(generator, interfaces);
        return interfaces.toArray(new Class[0]);
    }

    private static void addInterfaces(Object obj, Set<Class<?>> interfaces) {
        Class<?>[] generatorInterfaces = null;
        Class<Object> superClass = null;
        if (obj instanceof Class) {
            generatorInterfaces = ((Class)obj).getInterfaces();
            superClass = ((Class)obj).getSuperclass();
        } else {
            generatorInterfaces = obj.getClass().getInterfaces();
            superClass = obj.getClass().getSuperclass();
        }
        for (int i = 0; i < generatorInterfaces.length; ++i) {
            interfaces.add(generatorInterfaces[i]);
            ResourceGeneratorReaderProxyFactory.addInterfaces(generatorInterfaces[i], interfaces);
        }
        if (superClass != null && superClass != Object.class) {
            ResourceGeneratorReaderProxyFactory.addInterfaces(superClass, interfaces);
        }
    }

    private static class ResourceGeneratorReaderWrapperInvocationHandler
    implements InvocationHandler {
        private ResourceGenerator generator;
        private ResourceGeneratorReaderWrapper rsReaderWrapper;
        private StreamResourceGeneratorReaderWrapper streamRsReaderWrapper;
        private static Method[] resourceReaderMethods = TextResourceReader.class.getMethods();
        private static Method[] streamResourceReaderMethods = StreamResourceReader.class.getMethods();

        public ResourceGeneratorReaderWrapperInvocationHandler(ResourceGenerator generator, ResourceReaderHandler rsReaderHandler, JawrConfig config) {
            this.generator = generator;
            if (generator instanceof TextResourceGenerator) {
                this.rsReaderWrapper = new ResourceGeneratorReaderWrapper((TextResourceGenerator)generator, rsReaderHandler, config);
            }
            if (generator instanceof StreamResourceGenerator) {
                this.streamRsReaderWrapper = new StreamResourceGeneratorReaderWrapper((StreamResourceGenerator)generator, rsReaderHandler, config);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            result = this.rsReaderWrapper != null && this.methodBelongsTo(method, resourceReaderMethods) ? method.invoke((Object)this.rsReaderWrapper, args) : (this.streamRsReaderWrapper != null && this.methodBelongsTo(method, streamResourceReaderMethods) ? method.invoke((Object)this.streamRsReaderWrapper, args) : method.invoke((Object)this.generator, args));
            return result;
        }

        private boolean methodBelongsTo(Method m, Method[] methods) {
            boolean result = false;
            for (int i = 0; i < methods.length && !result; ++i) {
                if (!this.methodEquals(methods[i], m)) continue;
                result = true;
            }
            return result;
        }

        private boolean methodEquals(Method method, Method other) {
            if (method.getDeclaringClass().equals(other.getDeclaringClass()) && method.getName().equals(other.getName())) {
                Class<?>[] params2;
                if (!method.getReturnType().equals(other.getReturnType())) {
                    return false;
                }
                Class<?>[] params1 = method.getParameterTypes();
                if (params1.length == (params2 = other.getParameterTypes()).length) {
                    for (int i = 0; i < params1.length; ++i) {
                        if (params1[i] == params2[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

