/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathGeneratorHelper;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.CSSURLPathRewriterPostProcessor;
import net.jawr.web.resource.handler.reader.WorkingDirectoryLocationAware;

public class ClassPathCSSGenerator
extends AbstractCSSGenerator
implements ConfigurationAwareResourceGenerator,
WorkingDirectoryLocationAware {
    private static final String TEMP_CSS_CLASSPATH_SUBDIR = "cssClasspath";
    private ResourceGeneratorResolver resolver;
    private ClassPathGeneratorHelper helper = new ClassPathGeneratorHelper();
    private String workingDir;
    private boolean isHandlingCssImage;

    public ClassPathCSSGenerator() {
        this.resolver = ResourceGeneratorResolverFactory.createPrefixResolver("jar");
    }

    @Override
    public void setConfig(JawrConfig config) {
        this.isHandlingCssImage = config.isCssClasspathImageHandledByClasspathCss();
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isHandlingCssImage() {
        return this.isHandlingCssImage;
    }

    @Override
    public void setWorkingDirectory(String workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    protected Reader generateResourceForBundle(GeneratorContext context) {
        Reader reader = this.helper.createResource(context);
        if (reader != null) {
            reader = this.createTempResource(context, reader);
        }
        return reader;
    }

    @Override
    protected Reader generateResourceForDebug(GeneratorContext context) {
        Reader rd = null;
        if (context.getConfig().isCssClasspathImageHandledByClasspathCss()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(this.workingDir + "/" + TEMP_CSS_CLASSPATH_SUBDIR, context.getPath()));
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException("An error occured while creating temporary resource for " + context.getPath(), e);
            }
            if (fis != null) {
                FileChannel inchannel = fis.getChannel();
                rd = Channels.newReader(inchannel, context.getConfig().getResourceCharset().newDecoder(), -1);
            }
        } else {
            rd = this.helper.createResource(context);
        }
        return rd;
    }

    private Reader createTempResource(GeneratorContext generatorContext, Reader rd) {
        StringReader result = null;
        JoinableResourceBundleImpl tempBundle = new JoinableResourceBundleImpl("/jawr_generator.css", null, null, null, null, null, generatorContext.getConfig().getGeneratorRegistry());
        BundleProcessingStatus tempStatus = new BundleProcessingStatus("file", tempBundle, generatorContext.getResourceReaderHandler(), generatorContext.getConfig());
        CSSURLPathRewriterPostProcessor postProcessor = new CSSURLPathRewriterPostProcessor();
        String resourcePath = generatorContext.getPath();
        tempStatus.setLastPathAdded("jar:" + resourcePath);
        FileWriter fWriter = null;
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy(rd, writer, true);
            result = new StringReader(writer.getBuffer().toString());
            StringBuffer resourceData = postProcessor.postProcessBundle(tempStatus, writer.getBuffer());
            String tempCssClasspathDir = this.workingDir + "/" + TEMP_CSS_CLASSPATH_SUBDIR;
            File cssTempFile = new File(tempCssClasspathDir, resourcePath);
            File tempCssDir = cssTempFile.getParentFile();
            if (!tempCssDir.exists() && !tempCssDir.mkdirs()) {
                throw new BundlingProcessException("An error occured while creating temporary resource for " + resourcePath + ".\n" + "Enable to create temporary directory '" + tempCssClasspathDir + "'");
            }
            fWriter = new FileWriter(cssTempFile);
            IOUtils.copy(new StringReader(resourceData.toString()), fWriter, true);
        }
        catch (IOException e) {
            throw new BundlingProcessException("An error occured while creating temporary resource for " + resourcePath, e);
        }
        return result;
    }
}

